/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryDeadLetterVO;
import com.aizuda.snailjob.server.web.model.request.BatchRollBackRetryDeadLetterVO;
import com.aizuda.snailjob.server.web.model.request.RetryDeadLetterQueryVO;
import com.aizuda.snailjob.server.web.model.response.RetryDeadLetterResponseVO;
import com.aizuda.snailjob.server.web.service.RetryDeadLetterService;
import com.aizuda.snailjob.server.web.service.convert.RetryDeadLetterResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryDeadLetterServiceImpl
implements RetryDeadLetterService {
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;

    @Override
    public PageResult<List<RetryDeadLetterResponseVO>> getRetryDeadLetterPage(RetryDeadLetterQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        if (StrUtil.isBlank((CharSequence)queryVO.getGroupName())) {
            return new PageResult<List<RetryDeadLetterResponseVO>>(pageDTO, new ArrayList());
        }
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO retryDeadLetterPageDTO = this.accessTemplate.getRetryDeadLetterAccess().listPage(queryVO.getGroupName(), namespaceId, pageDTO, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetryDeadLetter::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetryDeadLetter::getSceneName, (Object)queryVO.getSceneName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getBizNo()), RetryDeadLetter::getBizNo, (Object)queryVO.getBizNo())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId()), RetryDeadLetter::getIdempotentId, (Object)queryVO.getIdempotentId())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId()), RetryDeadLetter::getUniqueId, (Object)queryVO.getUniqueId())).between(ObjUtil.isAllNotEmpty((Object[])new Object[]{queryVO.getStartDt(), queryVO.getEndDt()}), CreateDt::getCreateDt, (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).orderByDesc(RetryDeadLetter::getId));
        return new PageResult<List<RetryDeadLetterResponseVO>>(retryDeadLetterPageDTO, RetryDeadLetterResponseVOConverter.INSTANCE.convertList(retryDeadLetterPageDTO.getRecords()));
    }

    @Override
    public RetryDeadLetterResponseVO getRetryDeadLetterById(String groupName, Long id) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        RetryDeadLetter retryDeadLetter = (RetryDeadLetter)retryDeadLetterAccess.one(groupName, namespaceId, (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getId, (Object)id));
        return RetryDeadLetterResponseVOConverter.INSTANCE.convert(retryDeadLetter);
    }

    @Override
    @Transactional
    public int rollback(BatchRollBackRetryDeadLetterVO rollBackRetryDeadLetterVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        String groupName = rollBackRetryDeadLetterVO.getGroupName();
        List<Long> ids = rollBackRetryDeadLetterVO.getIds();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        List retryDeadLetterList = retryDeadLetterAccess.list(groupName, namespaceId, (LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryDeadLetter::getId, ids));
        Assert.notEmpty((Iterable)retryDeadLetterList, () -> new SnailJobServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        Set sceneNameSet = StreamUtils.toSet((Collection)retryDeadLetterList, RetryDeadLetter::getSceneName);
        List retrySceneConfigs = sceneConfigAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).in(RetrySceneConfig::getSceneName, (Collection)sceneNameSet));
        Map sceneConfigMap = StreamUtils.toIdentityMap((Collection)retrySceneConfigs, sceneConfig -> sceneConfig.getGroupName() + sceneConfig.getSceneName());
        ArrayList<RetryTask> waitRollbackList = new ArrayList<RetryTask>();
        for (RetryDeadLetter retryDeadLetter : retryDeadLetterList) {
            RetrySceneConfig retrySceneConfig = (RetrySceneConfig)sceneConfigMap.get(retryDeadLetter.getGroupName() + retryDeadLetter.getSceneName());
            Assert.notNull((Object)retrySceneConfig, () -> new SnailJobServerException("\u672a\u67e5\u8be2\u5230\u573a\u666f. [{}]", new Object[]{retryDeadLetter.getSceneName()}));
            RetryTask retryTask = RetryTaskConverter.INSTANCE.toRetryTask(retryDeadLetter);
            retryTask.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
            retryTask.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(LocalDateTime.now());
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
            retryTask.setNextTriggerAt(DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext)));
            retryTask.setCreateDt(LocalDateTime.now());
            waitRollbackList.add(retryTask);
        }
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        Assert.isTrue((waitRollbackList.size() == retryTaskAccess.insertBatch(groupName, namespaceId, waitRollbackList) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25"));
        Set waitDelRetryDeadLetterIdSet = StreamUtils.toSet((Collection)retryDeadLetterList, RetryDeadLetter::getId);
        Assert.isTrue((waitDelRetryDeadLetterIdSet.size() == retryDeadLetterAccess.delete(groupName, namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getGroupName, (Object)groupName)).in(RetryDeadLetter::getId, (Collection)waitDelRetryDeadLetterIdSet)) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u6b7b\u4fe1\u961f\u5217\u6570\u636e\u5931\u8d25"));
        RetryTaskLog retryTaskLog = new RetryTaskLog();
        retryTaskLog.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
        Set uniqueIdSet = StreamUtils.toSet(waitRollbackList, RetryTask::getUniqueId);
        int update = this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).in(RetryTaskLog::getUniqueId, (Collection)uniqueIdSet)).eq(RetryTaskLog::getGroupName, (Object)groupName));
        Assert.isTrue((update == uniqueIdSet.size() ? 1 : 0) != 0, () -> new SnailJobServerException("\u56de\u6eda\u65e5\u5fd7\u72b6\u6001\u5931\u8d25, \u53ef\u80fd\u539f\u56e0: \u65e5\u5fd7\u4fe1\u606f\u7f3a\u5931\u6216\u5b58\u5728\u591a\u4e2a\u76f8\u540cuniqueId"));
        return update;
    }

    @Override
    public int batchDelete(BatchDeleteRetryDeadLetterVO deadLetterVO) {
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        return retryDeadLetterAccess.delete(deadLetterVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getNamespaceId, (Object)namespaceId)).eq(RetryDeadLetter::getGroupName, (Object)deadLetterVO.getGroupName())).in(RetryDeadLetter::getId, deadLetterVO.getIds()));
    }
}

