/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NotifyConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.NotifyConfigResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyConfigService;
import com.aizuda.snailjob.server.web.service.convert.NotifyConfigConverter;
import com.aizuda.snailjob.server.web.service.convert.NotifyConfigResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.SyncConfigHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class NotifyConfigServiceImpl
implements NotifyConfigService {
    private final AccessTemplate accessTemplate;
    private final NotifyRecipientMapper notifyRecipientMapper;
    private final JobMapper jobMapper;
    private final WorkflowMapper workflowMapper;

    @Override
    public PageResult<List<NotifyConfigResponseVO>> getNotifyConfigList(NotifyConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List notifyConfigs = this.accessTemplate.getNotifyConfigAccess().listPage(pageDTO, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), NotifyConfig::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), NotifyConfig::getGroupName, (Object)queryVO.getGroupName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), NotifyConfig::getBusinessId, (Object)queryVO.getSceneName())).orderByDesc(NotifyConfig::getId)).getRecords();
        if (CollUtil.isEmpty((Collection)notifyConfigs)) {
            return new PageResult<List<NotifyConfigResponseVO>>(pageDTO, Lists.newArrayList());
        }
        List<NotifyConfigResponseVO> notifyConfigResponseVOS = NotifyConfigResponseVOConverter.INSTANCE.convertList(notifyConfigs);
        Map<Long, String> recipientNameMap = this.getRecipientNameMap(notifyConfigResponseVOS);
        Map<Long, String> jobNameMap = this.getJobNameMap(notifyConfigResponseVOS);
        Map<Long, String> workflowNameMap = this.getWorkflowNameMap(notifyConfigResponseVOS);
        for (NotifyConfigResponseVO notifyConfigResponseVO : notifyConfigResponseVOS) {
            notifyConfigResponseVO.setRecipientNames(StreamUtils.toSet(notifyConfigResponseVO.getRecipientIds(), recipientId -> recipientNameMap.getOrDefault(recipientId, "")));
            if (Objects.equals(notifyConfigResponseVO.getSystemTaskType(), SyetemTaskTypeEnum.RETRY.getType()) || Objects.equals(notifyConfigResponseVO.getSystemTaskType(), SyetemTaskTypeEnum.CALLBACK.getType())) {
                notifyConfigResponseVO.setBusinessName(notifyConfigResponseVO.getBusinessId());
                continue;
            }
            if (Objects.equals(notifyConfigResponseVO.getSystemTaskType(), SyetemTaskTypeEnum.JOB.getType())) {
                notifyConfigResponseVO.setBusinessName(jobNameMap.get(Long.parseLong(notifyConfigResponseVO.getBusinessId())));
                continue;
            }
            if (!Objects.equals(notifyConfigResponseVO.getSystemTaskType(), SyetemTaskTypeEnum.WORKFLOW.getType())) continue;
            notifyConfigResponseVO.setBusinessName(workflowNameMap.get(Long.parseLong(notifyConfigResponseVO.getBusinessId())));
        }
        return new PageResult<List<NotifyConfigResponseVO>>(pageDTO, notifyConfigResponseVOS);
    }

    private Map<Long, String> getWorkflowNameMap(List<NotifyConfigResponseVO> notifyConfigResponseVOS) {
        Set workflowIds = notifyConfigResponseVOS.stream().filter(responseVO -> responseVO.getSystemTaskType().equals(SyetemTaskTypeEnum.WORKFLOW.getType())).map(responseVO -> Long.parseLong(responseVO.getBusinessId())).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(workflowIds)) {
            List workflows = this.workflowMapper.selectBatchIds(workflowIds);
            return StreamUtils.toMap((Collection)workflows, Workflow::getId, Workflow::getWorkflowName);
        }
        return new HashMap<Long, String>();
    }

    private Map<Long, String> getJobNameMap(List<NotifyConfigResponseVO> notifyConfigResponseVOS) {
        Set jobIds = notifyConfigResponseVOS.stream().filter(responseVO -> responseVO.getSystemTaskType().equals(SyetemTaskTypeEnum.JOB.getType())).map(responseVO -> Long.parseLong(responseVO.getBusinessId())).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(jobIds)) {
            List jobs = this.jobMapper.selectBatchIds(jobIds);
            return StreamUtils.toMap((Collection)jobs, Job::getId, Job::getJobName);
        }
        return new HashMap<Long, String>();
    }

    @NotNull
    private Map<Long, String> getRecipientNameMap(List<NotifyConfigResponseVO> notifyConfigResponseVOS) {
        Set recipientIds = StreamUtils.toSetByFlatMap(notifyConfigResponseVOS, NotifyConfigResponseVO::getRecipientIds, Collection::stream);
        if (CollUtil.isEmpty((Collection)recipientIds)) {
            return Maps.newHashMap();
        }
        List notifyRecipients = this.notifyRecipientMapper.selectBatchIds((Collection)recipientIds);
        return StreamUtils.toMap((Collection)notifyRecipients, NotifyRecipient::getId, NotifyRecipient::getRecipientName);
    }

    @Override
    public Boolean saveNotify(NotifyConfigRequestVO requestVO) {
        NotifyConfig notifyConfig = NotifyConfigConverter.INSTANCE.convert(requestVO);
        notifyConfig.setCreateDt(LocalDateTime.now());
        notifyConfig.setRecipientIds(JsonUtil.toJsonString(requestVO.getRecipientIds()));
        notifyConfig.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        ConfigAccess notifyConfigAccess = this.accessTemplate.getNotifyConfigAccess();
        Assert.isTrue((1 == notifyConfigAccess.insert((Object)notifyConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to insert notify. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)notifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateNotify(NotifyConfigRequestVO requestVO) {
        Assert.notNull((Object)requestVO.getId(), () -> new SnailJobServerException("\u53c2\u6570\u5f02\u5e38"));
        NotifyConfig notifyConfig = NotifyConfigConverter.INSTANCE.convert(requestVO);
        notifyConfig.setRecipientIds(JsonUtil.toJsonString(requestVO.getRecipientIds()));
        notifyConfig.setNamespaceId(null);
        Assert.isTrue((1 == this.accessTemplate.getNotifyConfigAccess().updateById((Object)notifyConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to update notify. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)notifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public NotifyConfigResponseVO getNotifyConfigDetail(Long id) {
        NotifyConfig notifyConfig = (NotifyConfig)this.accessTemplate.getNotifyConfigAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getId, (Object)id));
        return NotifyConfigResponseVOConverter.INSTANCE.convert(notifyConfig);
    }

    @Override
    public Boolean updateStatus(Long id, Integer status) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        NotifyConfig notifyConfig = (NotifyConfig)this.accessTemplate.getNotifyConfigAccess().one((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getId, (Object)id)).eq(NotifyConfig::getNamespaceId, (Object)namespaceId));
        Assert.notNull((Object)notifyConfig, () -> new SnailJobServerException("\u901a\u77e5\u914d\u7f6e\u4e0d\u5b58\u5728"));
        SyncConfigHandler.addSyncTask(notifyConfig.getGroupName(), namespaceId);
        NotifyConfig config = new NotifyConfig();
        config.setNotifyStatus(status);
        config.setUpdateDt(LocalDateTime.now());
        int update = this.accessTemplate.getNotifyConfigAccess().update((Object)config, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(NotifyConfig::getNamespaceId, (Object)namespaceId)).eq(NotifyConfig::getId, (Object)id));
        return 1 == update;
    }

    @Override
    public Boolean batchDeleteNotify(Set<Long> ids) {
        return ids.size() == this.accessTemplate.getNotifyConfigAccess().delete((LambdaQueryWrapper)new LambdaQueryWrapper().in(NotifyConfig::getId, ids));
    }

    public NotifyConfigServiceImpl(AccessTemplate accessTemplate, NotifyRecipientMapper notifyRecipientMapper, JobMapper jobMapper, WorkflowMapper workflowMapper) {
        this.accessTemplate = accessTemplate;
        this.notifyRecipientMapper = notifyRecipientMapper;
        this.jobMapper = jobMapper;
        this.workflowMapper = workflowMapper;
    }
}

