/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NamespaceQueryVO;
import com.aizuda.snailjob.server.web.model.request.NamespaceRequestVO;
import com.aizuda.snailjob.server.web.model.response.NamespaceResponseVO;
import com.aizuda.snailjob.server.web.service.NamespaceService;
import com.aizuda.snailjob.server.web.service.convert.NamespaceResponseVOConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Namespace;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class NamespaceServiceImpl
implements NamespaceService {
    private final NamespaceMapper namespaceMapper;

    @Override
    public Boolean saveNamespace(NamespaceRequestVO namespaceRequestVO) {
        String uniqueId = namespaceRequestVO.getUniqueId();
        if (StrUtil.isNotBlank((CharSequence)namespaceRequestVO.getUniqueId())) {
            Pattern pattern = Pattern.compile("^[A-Za-z0-9_-]{1,64}$");
            Matcher matcher = pattern.matcher(uniqueId);
            Assert.isTrue((boolean)matcher.matches(), () -> new SnailJobServerException("\u4ec5\u652f\u6301\u957f\u5ea6\u4e3a1~64\u5b57\u7b26\u4e14\u7c7b\u578b\u4e3a\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u548c\u77ed\u6a2a\u7ebf"));
            Assert.isTrue((this.namespaceMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Namespace::getUniqueId, (Object)namespaceRequestVO.getUniqueId())) == 0L ? 1 : 0) != 0, () -> new SnailJobServerException("\u7a7a\u95f4\u552f\u4e00\u6807\u8bb0\u5df2\u7ecf\u5b58\u5728 {}", new Object[]{namespaceRequestVO.getUniqueId()}));
        }
        Namespace namespace = new Namespace();
        namespace.setName(namespaceRequestVO.getName());
        if (StrUtil.isBlank((CharSequence)uniqueId)) {
            namespace.setUniqueId(IdUtil.simpleUUID());
        } else {
            namespace.setUniqueId(uniqueId);
        }
        return 1 == this.namespaceMapper.insert((Object)namespace);
    }

    @Override
    public Boolean updateNamespace(NamespaceRequestVO namespaceRequestVO) {
        Long id = namespaceRequestVO.getId();
        Assert.notNull((Object)id, () -> new SnailJobServerException("\u53c2\u6570\u9519\u8bef"));
        Namespace namespace = new Namespace();
        namespace.setName(namespaceRequestVO.getName());
        namespace.setId(id);
        return 1 == this.namespaceMapper.updateById((Object)namespace);
    }

    @Override
    public PageResult<List<NamespaceResponseVO>> getNamespacePage(NamespaceQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        String keywords = StrUtil.trim((CharSequence)queryVO.getKeyword());
        PageDTO selectPage = (PageDTO)this.namespaceMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Namespace::getDeleted, (Object)StatusEnum.NO.getStatus())).and(StrUtil.isNotBlank((CharSequence)keywords), w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.likeRight(Namespace::getName, (Object)keywords)).or()).likeRight(Namespace::getUniqueId, (Object)keywords))).orderByDesc(Namespace::getId));
        return new PageResult<List<NamespaceResponseVO>>(pageDTO, NamespaceResponseVOConverter.INSTANCE.convertList(selectPage.getRecords()));
    }

    @Override
    public Boolean deleteNamespace(Long id) {
        return 1 == this.namespaceMapper.deleteById((Serializable)id);
    }

    @Override
    public List<NamespaceResponseVO> getAllNamespace() {
        List namespaces = this.namespaceMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Namespace::getName, Namespace::getUniqueId}).orderByDesc(Namespace::getId));
        return NamespaceResponseVOConverter.INSTANCE.convertList(namespaces);
    }

    public NamespaceServiceImpl(NamespaceMapper namespaceMapper) {
        this.namespaceMapper = namespaceMapper;
    }
}

