/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryTaskVO;
import com.aizuda.snailjob.server.web.model.request.GenerateRetryIdempotentIdVO;
import com.aizuda.snailjob.server.web.model.request.ManualTriggerTaskRequestVO;
import com.aizuda.snailjob.server.web.model.request.ParseLogsVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskSaveRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskUpdateExecutorNameRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskUpdateStatusRequestVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retry-task"})
public class RetryTaskController {
    @Autowired
    private RetryTaskService retryTaskService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<RetryTaskResponseVO>> getRetryTaskPage(RetryTaskQueryVO queryVO) {
        return this.retryTaskService.getRetryTaskPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public RetryTaskResponseVO getRetryTaskById(@RequestParam(value="groupName") String groupName, @PathVariable(value="id") Long id) {
        return this.retryTaskService.getRetryTaskById(groupName, id);
    }

    @LoginRequired
    @PutMapping(value={"status"})
    public int updateRetryTaskStatus(@RequestBody RetryTaskUpdateStatusRequestVO retryTaskUpdateStatusRequestVO) {
        return this.retryTaskService.updateRetryTaskStatus(retryTaskUpdateStatusRequestVO);
    }

    @LoginRequired
    @PostMapping
    public int saveRetryTask(@RequestBody @Validated RetryTaskSaveRequestVO retryTaskRequestVO) {
        return this.retryTaskService.saveRetryTask(retryTaskRequestVO);
    }

    @LoginRequired
    @PostMapping(value={"/generate/idempotent-id"})
    public Result<String> idempotentIdGenerate(@RequestBody @Validated GenerateRetryIdempotentIdVO generateRetryIdempotentIdVO) {
        return new Result((Object)this.retryTaskService.idempotentIdGenerate(generateRetryIdempotentIdVO));
    }

    @LoginRequired
    @PutMapping(value={"/batch"})
    public Integer updateRetryTaskExecutorName(@RequestBody @Validated RetryTaskUpdateExecutorNameRequestVO requestVO) {
        return this.retryTaskService.updateRetryTaskExecutorName(requestVO);
    }

    @LoginRequired
    @DeleteMapping(value={"/batch"})
    public Integer deleteRetryTask(@RequestBody @Validated BatchDeleteRetryTaskVO requestVO) {
        return this.retryTaskService.deleteRetryTask(requestVO);
    }

    @LoginRequired
    @PostMapping(value={"/batch"})
    public Integer parseLogs(@RequestBody @Validated ParseLogsVO parseLogsVO) {
        return this.retryTaskService.parseLogs(parseLogsVO);
    }

    @LoginRequired
    @PostMapping(value={"/manual/trigger/retry/task"})
    public boolean manualTriggerRetryTask(@RequestBody @Validated ManualTriggerTaskRequestVO requestVO) {
        return this.retryTaskService.manualTriggerRetryTask(requestVO);
    }

    @LoginRequired
    @PostMapping(value={"/manual/trigger/callback/task"})
    public boolean manualTriggerCallbackTask(@RequestBody @Validated ManualTriggerTaskRequestVO requestVO) {
        return this.retryTaskService.manualTriggerCallbackTask(requestVO);
    }
}

