/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.alarm.Alarm;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.NotifyConfigDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetrySceneConfigPartitionTask;
import com.aizuda.snailjob.server.retry.task.support.schedule.AbstractRetryTaskAlarmSchedule;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateUpdateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RetryErrorMoreThresholdAlarmSchedule
extends AbstractRetryTaskAlarmSchedule
implements Lifecycle {
    private static final String retryErrorMoreThresholdTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u573a\u666f\u91cd\u8bd5\u5931\u8d25\u6570\u91cf\u8d85\u8fc7{}\u4e2a</font>  \n> \u7a7a\u95f4ID:{}  \n> \u7ec4\u540d\u79f0:{}  \n> \u573a\u666f\u540d\u79f0:{}  \n> \u65f6\u95f4\u7a97\u53e3:{} ~ {}  \n> **\u5171\u8ba1:{}**  \n";

    public void start() {
        this.taskScheduler.scheduleWithFixedDelay(() -> ((RetryErrorMoreThresholdAlarmSchedule)this).execute(), Instant.now(), Duration.parse("PT10M"));
    }

    public void close() {
    }

    @Override
    protected void doSendAlarm(RetrySceneConfigPartitionTask partitionTask, Map<Long, NotifyConfigDTO> notifyConfigInfo) {
        if (CollUtil.isEmpty(partitionTask.getNotifyIds())) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        long count = this.accessTemplate.getRetryAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)partitionTask.getNamespaceId())).between(CreateUpdateDt::getUpdateDt, (Object)now.minusMinutes(30L), (Object)now)).eq(Retry::getGroupName, (Object)partitionTask.getGroupName())).eq(Retry::getSceneName, (Object)partitionTask.getSceneName())).eq(Retry::getRetryStatus, (Object)RetryStatusEnum.MAX_COUNT.getStatus()));
        for (Long notifyId : partitionTask.getNotifyIds()) {
            NotifyConfigDTO notifyConfigDTO = notifyConfigInfo.get(notifyId);
            if (notifyConfigDTO == null || notifyConfigDTO.getNotifyThreshold() <= 0 || count < (long)notifyConfigDTO.getNotifyThreshold().intValue()) continue;
            List<NotifyConfigDTO.RecipientInfo> recipientInfos = notifyConfigDTO.getRecipientInfos();
            for (NotifyConfigDTO.RecipientInfo recipientInfo : recipientInfos) {
                if (Objects.isNull(recipientInfo)) continue;
                AlarmContext context = AlarmContext.build().text(retryErrorMoreThresholdTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), count, partitionTask.getNamespaceId(), partitionTask.getGroupName(), partitionTask.getSceneName(), DateUtils.format((LocalDateTime)now.minusMinutes(30L), (DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN), count}).title("{}\u73af\u5883 \u573a\u666f\u91cd\u8bd5\u5931\u8d25\u6570\u91cf\u8d85\u8fc7\u9608\u503c", new Object[]{EnvironmentUtils.getActiveProfile()}).notifyAttribute(recipientInfo.getNotifyAttribute());
                Alarm alarmType = SnailJobAlarmFactory.getAlarmType((Integer)recipientInfo.getNotifyType());
                alarmType.asyncSendMessage((Object)context);
            }
        }
    }

    @Override
    protected RetryNotifySceneEnum getNotifyScene() {
        return RetryNotifySceneEnum.MAX_RETRY_ERROR;
    }

    public String lockName() {
        return "retryErrorMoreThreshold";
    }

    public String lockAtMost() {
        return "PT10M";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    @Generated
    public RetryErrorMoreThresholdAlarmSchedule() {
    }
}

