/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.dto.ScanTask;
import com.aizuda.snailjob.server.common.enums.RetryTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryPartitionTask;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskPrepareDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.handler.RateLimiterHandler;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ScanRetryActor")
@Scope(value="prototype")
public class ScanRetryActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScanRetryActor.class);
    private final SystemProperties systemProperties;
    private final AccessTemplate accessTemplate;
    private final RetryMapper retryMapper;
    private final GroupConfigMapper groupConfigMapper;
    private final RateLimiterHandler rateLimiterHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ScanTask.class, config -> {
            try {
                this.doScan((ScanTask)config);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Data scanner processing exception. [{}]", new Object[]{config, e});
            }
        }).build();
    }

    private void doScan(ScanTask scanTask) {
        PartitionTaskUtils.process(startId -> this.listAvailableTasks(startId, scanTask.getBuckets()), this::processRetryPartitionTasks, this::stopCondition, (long)0L);
    }

    private boolean stopCondition(List<? extends PartitionTask> partitionTasks) {
        if (CollectionUtils.isEmpty(partitionTasks)) {
            return true;
        }
        if (!this.rateLimiterHandler.tryAcquire(partitionTasks.size())) {
            log.warn("\u5f53\u524d\u8282\u70b9\u89e6\u53d1\u9650\u6d41");
            return true;
        }
        return false;
    }

    private void processRetryPartitionTasks(List<? extends PartitionTask> partitionTasks) {
        if (CollUtil.isEmpty(partitionTasks)) {
            return;
        }
        Map<String, RetrySceneConfig> sceneConfigMap = this.getSceneConfigMap(partitionTasks);
        ArrayList<Retry> waitUpdateRetries = new ArrayList<Retry>();
        ArrayList<RetryTaskPrepareDTO> waitExecRetries = new ArrayList<RetryTaskPrepareDTO>();
        for (PartitionTask partitionTask : partitionTasks) {
            RetryPartitionTask retryPartitionTask = (RetryPartitionTask)partitionTask;
            RetrySceneConfig retrySceneConfig = sceneConfigMap.get(retryPartitionTask.getSceneName());
            if (Objects.isNull(retrySceneConfig)) continue;
            this.processRetry(retryPartitionTask, retrySceneConfig, waitExecRetries, waitUpdateRetries);
        }
        if (CollUtil.isEmpty(waitUpdateRetries)) {
            return;
        }
        this.retryMapper.updateBatchNextTriggerAtById(waitUpdateRetries);
        for (RetryTaskPrepareDTO retryTaskPrepareDTO : waitExecRetries) {
            ActorRef actorRef = ActorGenerator.retryTaskPrepareActor();
            actorRef.tell((Object)retryTaskPrepareDTO, actorRef);
        }
    }

    private Map<String, RetrySceneConfig> getSceneConfigMap(List<? extends PartitionTask> partitionTasks) {
        Set sceneNameSet = StreamUtils.toSet(partitionTasks, partitionTask -> ((RetryPartitionTask)((Object)partitionTask)).getSceneName());
        List retrySceneConfigs = this.accessTemplate.getSceneConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetrySceneConfig::getBackOff, RetrySceneConfig::getTriggerInterval, RetrySceneConfig::getBlockStrategy, RetrySceneConfig::getSceneName, RetrySceneConfig::getCbTriggerType, RetrySceneConfig::getCbTriggerInterval, RetrySceneConfig::getExecutorTimeout}).eq(RetrySceneConfig::getSceneStatus, (Object)StatusEnum.YES.getStatus())).in(RetrySceneConfig::getSceneName, (Collection)sceneNameSet));
        return StreamUtils.toIdentityMap((Collection)retrySceneConfigs, RetrySceneConfig::getSceneName);
    }

    private void processRetry(RetryPartitionTask partitionTask, RetrySceneConfig retrySceneConfig, List<RetryTaskPrepareDTO> waitExecRetries, List<Retry> waitUpdateRetries) {
        Retry retry = new Retry();
        retry.setNextTriggerAt(this.calculateNextTriggerTime(partitionTask, retrySceneConfig));
        retry.setId(partitionTask.getId());
        waitUpdateRetries.add(retry);
        RetryTaskPrepareDTO retryTaskPrepareDTO = RetryTaskConverter.INSTANCE.toRetryTaskPrepareDTO(partitionTask);
        retryTaskPrepareDTO.setBlockStrategy(retrySceneConfig.getBlockStrategy());
        retryTaskPrepareDTO.setExecutorTimeout(retrySceneConfig.getExecutorTimeout());
        retryTaskPrepareDTO.setRetryTaskExecutorScene(RetryTaskExecutorSceneEnum.AUTO_RETRY.getScene());
        waitExecRetries.add(retryTaskPrepareDTO);
    }

    protected Long calculateNextTriggerTime(RetryPartitionTask partitionTask, RetrySceneConfig retrySceneConfig) {
        WaitStrategy waitStrategy;
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        long now = DateUtils.toNowMilli();
        long nextTriggerAt = partitionTask.getNextTriggerAt();
        if (nextTriggerAt + DateUtils.toEpochMilli((long)SystemConstants.SCHEDULE_PERIOD) < now) {
            nextTriggerAt = now;
            partitionTask.setNextTriggerAt(nextTriggerAt);
        }
        waitStrategyContext.setNextTriggerAt(nextTriggerAt);
        waitStrategyContext.setDelayLevel(Integer.valueOf(partitionTask.getRetryCount() + 1));
        if (SyetemTaskTypeEnum.CALLBACK.getType().equals(partitionTask.getTaskType())) {
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getCbTriggerInterval());
            waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getCbTriggerType());
        } else {
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
            waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
        }
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    public List<RetryPartitionTask> listAvailableTasks(Long startId, Set<Integer> buckets) {
        List retries = this.accessTemplate.getRetryAccess().listPage(new PageDTO(0L, (long)this.systemProperties.getRetryPullPageSize()), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Retry::getId, Retry::getNextTriggerAt, Retry::getGroupName, Retry::getRetryCount, Retry::getSceneName, Retry::getNamespaceId, Retry::getTaskType}).eq(Retry::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus())).in(Retry::getBucketIndex, buckets)).le(Retry::getNextTriggerAt, (Object)(DateUtils.toNowMilli() + DateUtils.toEpochMilli((long)SystemConstants.SCHEDULE_PERIOD)))).gt(Retry::getId, (Object)startId)).orderByAsc(Retry::getId)).getRecords();
        if (CollUtil.isNotEmpty((Collection)retries)) {
            List groupConfigs = StreamUtils.toList((Collection)this.groupConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{GroupConfig::getGroupName}).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus())).in(GroupConfig::getGroupName, (Collection)StreamUtils.toSet((Collection)retries, Retry::getGroupName))), GroupConfig::getGroupName);
            retries = retries.stream().filter(retry -> groupConfigs.contains(retry.getGroupName())).collect(Collectors.toList());
        }
        return RetryTaskConverter.INSTANCE.toRetryPartitionTasks(retries);
    }

    @Generated
    public ScanRetryActor(SystemProperties systemProperties, AccessTemplate accessTemplate, RetryMapper retryMapper, GroupConfigMapper groupConfigMapper, RateLimiterHandler rateLimiterHandler) {
        this.systemProperties = systemProperties;
        this.accessTemplate = accessTemplate;
        this.retryMapper = retryMapper;
        this.groupConfigMapper = groupConfigMapper;
        this.rateLimiterHandler = rateLimiterHandler;
    }
}

