/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.retry.task.dto.TaskStopJobDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.handler.RetryTaskStopHandler;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import io.netty.util.Timeout;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.Generated;

public class RetryTimeoutCheckTask
implements TimerTask<String> {
    private static final String IDEMPOTENT_KEY_PREFIX = "retry_timeout_check_{0}";
    private final Long retryTaskId;
    private final Long retryId;
    private final RetryTaskStopHandler retryTaskStopHandler;
    private final RetryMapper retryMapper;
    private final RetryTaskMapper retryTaskMapper;

    public void run(Timeout timeout) throws Exception {
        RetryTimerWheel.clearCache(this.idempotentKey());
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectById((Serializable)this.retryTaskId);
        if (Objects.isNull(retryTask)) {
            SnailJobLog.LOCAL.error("retryTaskId:[{}] \u4e0d\u5b58\u5728", new Object[]{this.retryTaskId});
            return;
        }
        if (RetryTaskStatusEnum.TERMINAL_STATUS_SET.contains(retryTask.getTaskStatus())) {
            return;
        }
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)this.retryId);
        if (Objects.isNull(retry)) {
            SnailJobLog.LOCAL.error("retryId:[{}]\u4e0d\u5b58\u5728", new Object[]{this.retryId});
            return;
        }
        String reason = "\u8d85\u65f6\u4e2d\u65ad.retryTaskId:[" + this.retryTaskId + "]";
        TaskStopJobDTO stopJobDTO = RetryTaskConverter.INSTANCE.toTaskStopJobDTO(retry);
        stopJobDTO.setRetryTaskId(this.retryTaskId);
        stopJobDTO.setRetryId(this.retryId);
        stopJobDTO.setOperationReason(JobOperationReasonEnum.TASK_EXECUTION_TIMEOUT.getReason());
        stopJobDTO.setNeedUpdateTaskStatus(true);
        this.retryTaskStopHandler.stop(stopJobDTO);
        SnailJobLog.LOCAL.info(reason, new Object[0]);
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.retryId);
    }

    @Generated
    public RetryTimeoutCheckTask(Long retryTaskId, Long retryId, RetryTaskStopHandler retryTaskStopHandler, RetryMapper retryMapper, RetryTaskMapper retryTaskMapper) {
        this.retryTaskId = retryTaskId;
        this.retryId = retryId;
        this.retryTaskStopHandler = retryTaskStopHandler;
        this.retryMapper = retryMapper;
        this.retryTaskMapper = retryTaskMapper;
    }
}

