/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.prepare;

import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskPrepareDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryPrePareHandler;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerWheel;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WaitRetryPrepareHandler
implements RetryPrePareHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WaitRetryPrepareHandler.class);

    @Override
    public boolean matches(Integer status) {
        return Objects.equals(RetryTaskStatusEnum.WAITING.getStatus(), status);
    }

    @Override
    public void handle(RetryTaskPrepareDTO prepare) {
        if (!RetryTimerWheel.isExisted(MessageFormat.format("retry_task_{0}", prepare.getRetryTaskId()))) {
            log.info("\u5b58\u5728\u5f85\u5904\u7406\u4efb\u52a1\u4e14\u65f6\u95f4\u8f6e\u4e2d\u4e0d\u5b58\u5728 retryTaskId:[{}]", (Object)prepare.getRetryTaskId());
            long delay = prepare.getNextTriggerAt() - DateUtils.toNowMilli();
            RetryTimerContext timerContext = RetryTaskConverter.INSTANCE.toRetryTimerContext(prepare);
            RetryTimerWheel.registerWithRetry(() -> new RetryTimerTask(timerContext), Duration.ofMillis(delay));
        }
    }
}

