/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.listener;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.alarm.AbstractRetryAlarm;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.dto.RetryAlarmInfo;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskFailDeadLetterAlarmEventDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailDeadLetterAlarmEvent;
import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class RetryTaskFailDeadLetterAlarmListener
extends AbstractRetryAlarm<RetryTaskFailDeadLetterAlarmEvent>
implements Runnable,
Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryTaskFailDeadLetterAlarmListener.class);
    private final LinkedBlockingQueue<List<RetryTaskFailDeadLetterAlarmEventDTO>> queue = new LinkedBlockingQueue(1000);
    private static final String retryTaskDeadTextMessagesFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u91cd\u8bd5\u4efb\u52a1\u5931\u8d25\u8fdb\u5165\u6b7b\u4fe1\u961f\u5217</font>  \n> \u7a7a\u95f4ID:{}  \n> \u7ec4\u540d\u79f0:{}  \n> \u6267\u884c\u5668\u540d\u79f0:{}  \n> \u573a\u666f\u540d\u79f0:{}  \n> \u4e1a\u52a1\u6570\u636e:{}  \n> \u65f6\u95f4:{}  \n";

    protected List<SyetemTaskTypeEnum> getSystemTaskType() {
        return Lists.newArrayList((Object[])new SyetemTaskTypeEnum[]{SyetemTaskTypeEnum.RETRY});
    }

    protected List<RetryAlarmInfo> poll() throws InterruptedException {
        List<RetryTaskFailDeadLetterAlarmEventDTO> allRetryDeadLetterList = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (CollUtil.isEmpty(allRetryDeadLetterList)) {
            return Lists.newArrayList();
        }
        return RetryTaskConverter.INSTANCE.toRetryAlarmInfos(allRetryDeadLetterList);
    }

    @TransactionalEventListener(fallbackExecution=true, phase=TransactionPhase.AFTER_COMPLETION)
    public void doOnApplicationEvent(RetryTaskFailDeadLetterAlarmEvent event) {
        if (!this.queue.offer(event.getRetryDeadLetters())) {
            SnailJobLog.LOCAL.warn("\u4efb\u52a1\u91cd\u8bd5\u5931\u8d25\u8fdb\u5165\u6b7b\u4fe1\u961f\u5217\u544a\u8b66\u961f\u5217\u5df2\u6ee1", new Object[0]);
        }
    }

    protected AlarmContext buildAlarmContext(RetryAlarmInfo retryAlarmInfo, NotifyConfigInfo notifyConfig) {
        return AlarmContext.build().text(retryTaskDeadTextMessagesFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), retryAlarmInfo.getNamespaceId(), retryAlarmInfo.getGroupName(), retryAlarmInfo.getExecutorName(), retryAlarmInfo.getSceneName(), retryAlarmInfo.getArgsStr(), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN)}).title("\u7ec4:[{}] \u573a\u666f:[{}] \u73af\u5883\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25\u8fdb\u5165\u6b7b\u4fe1\u961f\u5217", new Object[]{retryAlarmInfo.getGroupName(), retryAlarmInfo.getSceneName()});
    }

    protected void startLog() {
        SnailJobLog.LOCAL.info("RetryTaskFailDeadLetterAlarmListener started", new Object[0]);
    }

    protected int getNotifyScene() {
        return RetryNotifySceneEnum.RETRY_TASK_ENTER_DEAD_LETTER.getNotifyScene();
    }
}

