/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.handler;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

@Component
public class CallbackRetryTaskHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackRetryTaskHandler.class);
    private final AccessTemplate accessTemplate;

    public void create(Retry parentRetry, RetrySceneConfig retrySceneConfig) {
        if (!SyetemTaskTypeEnum.RETRY.getType().equals(parentRetry.getTaskType())) {
            return;
        }
        if (Objects.isNull(retrySceneConfig.getCbStatus()) || StatusEnum.NO.getStatus().equals(retrySceneConfig.getCbStatus())) {
            return;
        }
        Retry callbackRetry = RetryTaskConverter.INSTANCE.toRetryTask(parentRetry);
        callbackRetry.setTaskType(SyetemTaskTypeEnum.CALLBACK.getType());
        callbackRetry.setParentId(parentRetry.getId());
        callbackRetry.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
        callbackRetry.setRetryCount(Integer.valueOf(0));
        callbackRetry.setCreateDt(LocalDateTime.now());
        callbackRetry.setUpdateDt(LocalDateTime.now());
        String triggerInterval = retrySceneConfig.getCbTriggerInterval();
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getCbTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setNextTriggerAt(DateUtils.toNowMilli());
        waitStrategyContext.setDelayLevel(Integer.valueOf(1));
        waitStrategyContext.setTriggerInterval(String.valueOf(triggerInterval));
        callbackRetry.setNextTriggerAt(waitStrategy.computeTriggerTime(waitStrategyContext));
        try {
            Assert.isTrue((1 == this.accessTemplate.getRetryAccess().insert((Object)callbackRetry) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to report data"));
        }
        catch (DuplicateKeyException e) {
            log.warn("\u56de\u8c03\u6570\u636e\u91cd\u590d\u65b0\u589e. [{}]", (Object)JsonUtil.toJsonString((Object)callbackRetry));
        }
    }

    public String getRetryTaskUniqueId(String callbackTaskUniqueId) {
        return callbackTaskUniqueId.substring(callbackTaskUniqueId.lastIndexOf("_") + 1);
    }

    @Generated
    public CallbackRetryTaskHandler(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

