/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import akka.actor.AbstractActor;
import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.enums.RetryTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskPrepareDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryPrePareHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RetryTaskPrepareActor")
@Scope(value="prototype")
public class RetryTaskPrepareActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryTaskPrepareActor.class);
    private final List<RetryPrePareHandler> retryPrePareHandlers;
    private final RetryTaskMapper retryTaskMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryTaskPrepareDTO.class, prepareDTO -> {
            try {
                this.doPrepare((RetryTaskPrepareDTO)prepareDTO);
            }
            catch (Exception e) {
                log.error("\u9884\u5904\u7406\u8282\u70b9\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doPrepare(RetryTaskPrepareDTO prepareDTO) {
        List retryTasks = this.retryTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getRetryId, (Object)prepareDTO.getRetryId())).in(RetryTask::getTaskStatus, (Collection)RetryTaskStatusEnum.NOT_COMPLETE)).orderByAsc(RetryTask::getRetryId));
        if (CollUtil.isEmpty((Collection)retryTasks) || Objects.isNull(prepareDTO.getRetryTaskExecutorScene()) || RetryTaskExecutorSceneEnum.MANUAL_RETRY.getScene() == prepareDTO.getRetryTaskExecutorScene().intValue()) {
            RetryTask retryTask = new RetryTask();
            retryTask.setTaskStatus(RetryTaskStatusEnum.SUCCESS.getStatus());
            retryTasks = Lists.newArrayList((Object[])new RetryTask[]{retryTask});
        }
        boolean onlyTimeoutCheck = false;
        for (RetryTask retryTask : retryTasks) {
            prepareDTO.setRetryTaskId(retryTask.getId());
            prepareDTO.setOnlyTimeoutCheck(onlyTimeoutCheck);
            for (RetryPrePareHandler retryPrePareHandler : this.retryPrePareHandlers) {
                if (!retryPrePareHandler.matches(retryTask.getTaskStatus())) continue;
                retryPrePareHandler.handle(prepareDTO);
                break;
            }
            onlyTimeoutCheck = true;
        }
    }

    @Generated
    public RetryTaskPrepareActor(List<RetryPrePareHandler> retryPrePareHandlers, RetryTaskMapper retryTaskMapper) {
        this.retryPrePareHandlers = retryPrePareHandlers;
        this.retryTaskMapper = retryTaskMapper;
    }
}

