/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.strategy;

import com.aizuda.snailjob.client.model.DispatchRetryResultDTO;
import com.aizuda.snailjob.common.core.enums.RetryResultStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.StopStrategy;
import com.aizuda.snailjob.server.retry.task.support.context.MaxAttemptsPersistenceRetryContext;
import java.util.Objects;

public class StopStrategies {
    private StopStrategies() {
    }

    public static StopStrategy stopException() {
        return new ExceptionStopStrategy();
    }

    public static StopStrategy stopResultStatus() {
        return new ResultStatusStopStrategy();
    }

    public static StopStrategy stopResultStatusCode() {
        return new ResultStatusCodeStopStrategy();
    }

    private static final class ExceptionStopStrategy
    implements StopStrategy {
        private ExceptionStopStrategy() {
        }

        @Override
        public boolean shouldStop(RetryContext retryContext) {
            return !retryContext.hasException();
        }

        @Override
        public boolean supports(RetryContext retryContext) {
            return true;
        }

        @Override
        public int order() {
            return 1;
        }
    }

    private static final class ResultStatusStopStrategy
    implements StopStrategy {
        private ResultStatusStopStrategy() {
        }

        @Override
        public boolean shouldStop(RetryContext retryContext) {
            Result response = (Result)retryContext.getCallResult();
            if (Objects.isNull(response) || StatusEnum.YES.getStatus().intValue() != response.getStatus()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public boolean supports(RetryContext retryContext) {
            return true;
        }

        @Override
        public int order() {
            return 2;
        }
    }

    private static final class ResultStatusCodeStopStrategy
    implements StopStrategy {
        private ResultStatusCodeStopStrategy() {
        }

        @Override
        public boolean shouldStop(RetryContext retryContext) {
            Result response = (Result)retryContext.getCallResult();
            if (Objects.isNull(response) || StatusEnum.YES.getStatus().intValue() != response.getStatus()) {
                return Boolean.FALSE;
            }
            DispatchRetryResultDTO data = (DispatchRetryResultDTO)response.getData();
            if (Objects.isNull(data)) {
                return Boolean.FALSE;
            }
            Integer statusCode = data.getStatusCode();
            Integer status = RetryResultStatusEnum.getRetryResultStatusEnum((int)statusCode).getStatus();
            return RetryResultStatusEnum.SUCCESS.getStatus().equals(status) || RetryResultStatusEnum.STOP.getStatus().equals(status);
        }

        @Override
        public boolean supports(RetryContext retryContext) {
            return retryContext instanceof MaxAttemptsPersistenceRetryContext;
        }

        @Override
        public int order() {
            return 3;
        }
    }
}

