/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.retry.task.support.idempotent.TimerIdempotent;
import io.netty.util.HashedWheelTimer;
import io.netty.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class RetryTimerWheel
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(RetryTimerWheel.class);
    private static final int TICK_DURATION = 500;
    private static final String THREAD_NAME_PREFIX = "retry-task-timer-wheel-";
    private static HashedWheelTimer timer = null;
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(16, 16, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("retry-task-timer-wheel-"));
    private static final TimerIdempotent idempotent = new TimerIdempotent();

    public void start() {
        timer = new HashedWheelTimer((ThreadFactory)new CustomizableThreadFactory(THREAD_NAME_PREFIX), 500L, TimeUnit.MILLISECONDS, 512, true, -1L, (Executor)executor);
        timer.start();
    }

    public static void register(Pair<String, String> pair, String uniqueId, TimerTask task, long delay, TimeUnit unit) {
        if (!RetryTimerWheel.isExisted(pair, uniqueId)) {
            delay = delay < 0L ? 0L : delay;
            try {
                timer.newTimeout(task, delay, unit);
                idempotent.set(pair, uniqueId);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u52a0\u5165\u65f6\u95f4\u8f6e\u5931\u8d25. uniqueId:[{}]", new Object[]{uniqueId, e});
            }
        }
    }

    public static boolean isExisted(Pair<String, String> pair, String uniqueId) {
        return idempotent.isExist(pair, uniqueId);
    }

    public static void clearCache(Pair<String, String> pair, String uniqueId) {
        idempotent.clear(pair, uniqueId);
    }

    public void close() {
        timer.stop();
    }
}

