/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.NotifyConfigPartitionTask;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RetryTaskMoreThresholdAlarmSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(RetryTaskMoreThresholdAlarmSchedule.class);
    private static final String retryTaskMoreThresholdTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u573a\u666f\u91cd\u8bd5\u6570\u91cf\u8d85\u8fc7{}\u4e2a</font>  \n> \u7a7a\u95f4ID:{}  \n> \u7ec4\u540d\u79f0:{}  \n> \u573a\u666f\u540d\u79f0:{}  \n> \u544a\u8b66\u65f6\u95f4:{}  \n> **\u5171\u8ba1:{}**  \n";
    private final AccessTemplate accessTemplate;
    private final NotifyRecipientMapper recipientMapper;

    public void start() {
        this.taskScheduler.scheduleWithFixedDelay(() -> ((RetryTaskMoreThresholdAlarmSchedule)this).execute(), Instant.now(), Duration.parse("PT10M"));
    }

    public void close() {
    }

    protected void doExecute() {
        PartitionTaskUtils.process(this::getNotifyConfigPartitions, this::doHandler, (long)0L);
    }

    private void doHandler(List<? extends PartitionTask> partitionTasks) {
        for (PartitionTask partitionTask : partitionTasks) {
            this.doSendAlarm((NotifyConfigPartitionTask)partitionTask);
        }
    }

    private void doSendAlarm(NotifyConfigPartitionTask partitionTask) {
        long count = this.accessTemplate.getRetryTaskAccess().count(partitionTask.getGroupName(), partitionTask.getNamespaceId(), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)partitionTask.getNamespaceId())).eq(RetryTask::getGroupName, (Object)partitionTask.getGroupName())).eq(RetryTask::getSceneName, (Object)partitionTask.getBusinessId())).eq(RetryTask::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus()));
        if (count >= (long)partitionTask.getNotifyThreshold().intValue()) {
            List<NotifyConfigPartitionTask.RecipientInfo> recipientInfos = partitionTask.getRecipientInfos();
            for (NotifyConfigPartitionTask.RecipientInfo recipientInfo : recipientInfos) {
                if (Objects.isNull(recipientInfo)) continue;
                AlarmContext context = AlarmContext.build().text(retryTaskMoreThresholdTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), count, partitionTask.getNamespaceId(), partitionTask.getGroupName(), partitionTask.getBusinessId(), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN), count}).title("{}\u73af\u5883 \u573a\u666f\u91cd\u8bd5\u6570\u91cf\u8d85\u8fc7\u9608\u503c", new Object[]{EnvironmentUtils.getActiveProfile()}).notifyAttribute(recipientInfo.getNotifyAttribute());
                Optional.ofNullable(SnailJobAlarmFactory.getAlarmType((Integer)recipientInfo.getNotifyType())).ifPresent(alarmType -> alarmType.asyncSendMessage((Object)context));
            }
        }
    }

    private List<NotifyConfigPartitionTask> getNotifyConfigPartitions(Long startId) {
        List notifyConfigs = this.accessTemplate.getNotifyConfigAccess().listPage(new PageDTO(startId.longValue(), 1000L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNotifyStatus, (Object)StatusEnum.YES.getStatus())).eq(NotifyConfig::getSystemTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).eq(NotifyConfig::getNotifyScene, (Object)RetryNotifySceneEnum.MAX_RETRY.getNotifyScene())).orderByDesc(NotifyConfig::getId)).getRecords();
        Set recipientIds = notifyConfigs.stream().flatMap(config -> JsonUtil.parseList((String)config.getRecipientIds(), Long.class).stream()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(recipientIds)) {
            return Lists.newArrayList();
        }
        Map recipientMap = StreamUtils.toIdentityMap((Collection)this.recipientMapper.selectBatchIds(recipientIds), NotifyRecipient::getId);
        List<NotifyConfigPartitionTask> notifyConfigPartitionTasks = RetryTaskConverter.INSTANCE.toNotifyConfigPartitionTask(notifyConfigs);
        notifyConfigPartitionTasks.forEach(task -> {
            List recipientList = StreamUtils.toList(task.getRecipientIds(), recipientId -> {
                NotifyRecipient notifyRecipient = (NotifyRecipient)recipientMap.get(recipientId);
                if (Objects.isNull(notifyRecipient)) {
                    return null;
                }
                NotifyConfigPartitionTask.RecipientInfo recipientInfo = new NotifyConfigPartitionTask.RecipientInfo();
                recipientInfo.setNotifyType(notifyRecipient.getNotifyType());
                recipientInfo.setNotifyAttribute(notifyRecipient.getNotifyAttribute());
                return recipientInfo;
            });
            task.setRecipientInfos(recipientList);
        });
        return notifyConfigPartitionTasks;
    }

    public String lockName() {
        return "retryTaskMoreThreshold";
    }

    public String lockAtMost() {
        return "PT10M";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    public RetryTaskMoreThresholdAlarmSchedule(AccessTemplate accessTemplate, NotifyRecipientMapper recipientMapper) {
        this.accessTemplate = accessTemplate;
        this.recipientMapper = recipientMapper;
    }
}

