/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.collection.CollectionUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.triple.Triple;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryMergePartitionTaskDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class RetryLogMergeSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(RetryLogMergeSchedule.class);
    private final SystemProperties systemProperties;
    private final RetryTaskLogMapper retryTaskLogMapper;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    private final TransactionTemplate transactionTemplate;
    private static Long lastMergeLogTime = 0L;

    public String lockName() {
        return "retryLogMerge";
    }

    public String lockAtMost() {
        return "PT1H";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        try {
            if (System.currentTimeMillis() - lastMergeLogTime < 86400000L) {
                return;
            }
            LocalDateTime endTime = LocalDateTime.now().minusDays(this.systemProperties.getMergeLogDays());
            long total = PartitionTaskUtils.process(startId -> this.retryLogList(startId, endTime), this::processJobLogPartitionTasks, (long)0L);
            SnailJobLog.LOCAL.debug("job merge success total:[{}]", new Object[]{total});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("job merge log error", new Object[]{e});
        }
        finally {
            lastMergeLogTime = System.currentTimeMillis();
        }
    }

    private List<RetryMergePartitionTaskDTO> retryLogList(Long startId, LocalDateTime endTime) {
        List jobTaskBatchList = ((Page)this.retryTaskLogMapper.selectPage((IPage)new Page(0L, 1000L), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ge(RetryTaskLog::getId, (Object)startId)).in(RetryTaskLog::getRetryStatus, (Collection)Lists.newArrayList((Object[])new Integer[]{RetryStatusEnum.FINISH.getStatus(), RetryStatusEnum.MAX_COUNT.getStatus()}))).le(RetryTaskLog::getCreateDt, (Object)endTime))).getRecords();
        return RetryTaskLogConverter.INSTANCE.toRetryMergePartitionTaskDTOs(jobTaskBatchList);
    }

    public void processJobLogPartitionTasks(List<? extends PartitionTask> partitionTasks) {
        List ids = StreamUtils.toList(partitionTasks, PartitionTask::getUniqueId);
        if (CollectionUtil.isEmpty((Collection)ids)) {
            return;
        }
        List retryLogMessageList = this.retryTaskLogMessageMapper.selectList((Wrapper)new LambdaQueryWrapper().in(RetryTaskLogMessage::getUniqueId, (Collection)ids));
        if (CollectionUtil.isEmpty((Collection)retryLogMessageList)) {
            return;
        }
        List jobLogMessageGroupList = retryLogMessageList.stream().collect(Collectors.groupingBy(message -> Triple.of((Object)message.getNamespaceId(), (Object)message.getGroupName(), (Object)message.getUniqueId()))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() >= 2).collect(Collectors.toList());
        for (Map.Entry jobLogMessageMap : jobLogMessageGroupList) {
            final ArrayList jobLogMessageDeleteBatchIds = new ArrayList();
            List mergeMessages = ((List)jobLogMessageMap.getValue()).stream().map(k -> {
                jobLogMessageDeleteBatchIds.add(k.getId());
                return (List)JsonUtil.parseObject((String)k.getMessage(), List.class);
            }).reduce((a, b) -> {
                ArrayList list = new ArrayList();
                list.addAll(a);
                list.addAll(b);
                return list;
            }).get();
            List partitionMessages = Lists.partition((List)mergeMessages, (int)this.systemProperties.getMergeLogNum());
            final ArrayList<RetryTaskLogMessage> jobLogMessageUpdateList = new ArrayList<RetryTaskLogMessage>();
            for (int i = 0; i < partitionMessages.size(); ++i) {
                RetryTaskLogMessage jobLogMessage = RetryTaskLogConverter.INSTANCE.toRetryTaskLogMessage((RetryTaskLogMessage)((List)jobLogMessageMap.getValue()).get(0));
                List messages = (List)partitionMessages.get(i);
                jobLogMessage.setLogNum(Integer.valueOf(messages.size()));
                jobLogMessage.setMessage(JsonUtil.toJsonString((Object)messages));
                jobLogMessageUpdateList.add(jobLogMessage);
            }
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    if (CollectionUtil.isNotEmpty((Collection)jobLogMessageDeleteBatchIds)) {
                        RetryLogMergeSchedule.this.retryTaskLogMessageMapper.deleteBatchIds((Collection)jobLogMessageDeleteBatchIds);
                    }
                    if (CollectionUtil.isNotEmpty((Collection)jobLogMessageUpdateList)) {
                        RetryLogMergeSchedule.this.retryTaskLogMessageMapper.insertBatch(jobLogMessageUpdateList);
                    }
                }
            });
        }
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((RetryLogMergeSchedule)this).execute(), Duration.parse("PT1H"));
    }

    public void close() {
    }

    public RetryLogMergeSchedule(SystemProperties systemProperties, RetryTaskLogMapper retryTaskLogMapper, RetryTaskLogMessageMapper retryTaskLogMessageMapper, TransactionTemplate transactionTemplate) {
        this.systemProperties = systemProperties;
        this.retryTaskLogMapper = retryTaskLogMapper;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
        this.transactionTemplate = transactionTemplate;
    }
}

