/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryPartitionTask;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ClearLogSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(ClearLogSchedule.class);
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    @Autowired
    private TransactionTemplate transactionTemplate;
    private static Long lastCleanLogTime = 0L;

    public String lockName() {
        return "clearLog";
    }

    public String lockAtMost() {
        return "PT1H";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        try {
            if (this.systemProperties.getLogStorage() <= 0 || System.currentTimeMillis() - lastCleanLogTime < 86400000L) {
                return;
            }
            LocalDateTime endTime = LocalDateTime.now().minusDays(this.systemProperties.getLogStorage());
            long total = PartitionTaskUtils.process(startId -> this.retryTaskBatchList(startId, endTime), this::processRetryLogPartitionTasks, (long)0L);
            SnailJobLog.LOCAL.debug("Retry clear success total:[{}]", new Object[]{total});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("clear log error", new Object[]{e});
        }
        finally {
            lastCleanLogTime = System.currentTimeMillis();
        }
    }

    private List<RetryPartitionTask> retryTaskBatchList(Long startId, LocalDateTime endTime) {
        List retryTaskLogList = ((Page)this.retryTaskLogMapper.selectPage((IPage)new Page(0L, 1000L), (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ge(RetryTaskLog::getId, (Object)startId)).le(RetryTaskLog::getCreateDt, (Object)endTime))).getRecords();
        return RetryTaskConverter.INSTANCE.toRetryTaskLogPartitionTasks(retryTaskLogList);
    }

    public void processRetryLogPartitionTasks(final List<? extends PartitionTask> partitionTasks) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List retryTaskLogMessageList;
                List uniqueIdIds = StreamUtils.toList((Collection)partitionTasks, PartitionTask::getUniqueId);
                if (uniqueIdIds == null || uniqueIdIds.size() == 0) {
                    return;
                }
                List retryTaskLogList = ClearLogSchedule.this.retryTaskLogMapper.selectList((Wrapper)new LambdaQueryWrapper().in(RetryTaskLog::getUniqueId, (Collection)uniqueIdIds));
                if (retryTaskLogList != null && retryTaskLogList.size() > 0) {
                    List retryTaskListIds = StreamUtils.toList((Collection)retryTaskLogList, RetryTaskLog::getId);
                    ClearLogSchedule.this.retryTaskLogMapper.deleteBatchIds((Collection)retryTaskListIds);
                }
                if ((retryTaskLogMessageList = ClearLogSchedule.this.retryTaskLogMessageMapper.selectList((Wrapper)new LambdaQueryWrapper().in(RetryTaskLogMessage::getUniqueId, (Collection)uniqueIdIds))) != null && retryTaskLogMessageList.size() > 0) {
                    List retryTaskListIds = StreamUtils.toList((Collection)retryTaskLogMessageList, RetryTaskLogMessage::getId);
                    ClearLogSchedule.this.retryTaskLogMessageMapper.deleteBatchIds((Collection)retryTaskListIds);
                }
            }
        });
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((ClearLogSchedule)this).execute(), Duration.parse("PT1H"));
    }

    public void close() {
    }
}

