/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.retry;

import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.support.FilterStrategy;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.StopStrategy;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class RetryBuilder<V> {
    private List<StopStrategy> stopStrategies;
    private WaitStrategy waitStrategy;
    private List<FilterStrategy> filterStrategies;
    private RetryContext<V> retryContext;

    public static <V> RetryBuilder<V> newBuilder() {
        return new RetryBuilder<V>();
    }

    public RetryBuilder<V> withWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RetryBuilder<V> withFilterStrategy(FilterStrategy filterStrategy) {
        if (CollectionUtils.isEmpty(this.filterStrategies)) {
            this.filterStrategies = new ArrayList<FilterStrategy>();
        }
        this.filterStrategies.add(filterStrategy);
        return this;
    }

    public RetryBuilder<V> withStopStrategy(StopStrategy stopStrategy) {
        if (CollectionUtils.isEmpty(this.stopStrategies)) {
            this.stopStrategies = new ArrayList<StopStrategy>();
        }
        this.stopStrategies.add(stopStrategy);
        return this;
    }

    public RetryBuilder<V> withRetryContext(RetryContext<V> retryContext) {
        this.retryContext = retryContext;
        return this;
    }

    public RetryExecutor<V> build() {
        if (Objects.isNull(this.waitStrategy)) {
            throw new SnailJobServerException("waitStrategy \u4e0d\u80fd\u4e3anull");
        }
        if (Objects.isNull(this.retryContext)) {
            throw new SnailJobServerException("retryContext \u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty(this.stopStrategies)) {
            this.stopStrategies = Collections.EMPTY_LIST;
        } else {
            this.stopStrategies.sort(Comparator.comparingInt(StopStrategy::order));
        }
        if (CollectionUtils.isEmpty(this.filterStrategies)) {
            this.filterStrategies = Collections.EMPTY_LIST;
        } else {
            this.filterStrategies.sort(Comparator.comparingInt(FilterStrategy::order));
        }
        this.retryContext.setWaitStrategy(this.waitStrategy);
        return new RetryExecutor<V>(this.stopStrategies, this.waitStrategy, this.filterStrategies, this.retryContext);
    }
}

