/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.task;

import akka.actor.ActorRef;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.client.model.DispatchRetryResultDTO;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.context.MaxAttemptsPersistenceRetryContext;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.AbstractTaskExecutor;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutorSceneEnum;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryBuilder;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import com.aizuda.snailjob.server.retry.task.support.strategy.FilterStrategies;
import com.aizuda.snailjob.server.retry.task.support.strategy.StopStrategies;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import org.springframework.stereotype.Component;

@Component
public class ManualRetryTaskExecutor
extends AbstractTaskExecutor {
    @Override
    protected RetryContext<Result<DispatchRetryResultDTO>> builderRetryContext(String groupName, RetryTask retryTask, RetrySceneConfig retrySceneConfig) {
        MaxAttemptsPersistenceRetryContext<Result<DispatchRetryResultDTO>> retryContext = new MaxAttemptsPersistenceRetryContext<Result<DispatchRetryResultDTO>>();
        retryContext.setRetryTask(retryTask);
        retryContext.setSceneBlacklist(this.accessTemplate.getSceneConfigAccess().getBlacklist(groupName, retrySceneConfig.getNamespaceId()));
        retryContext.setServerNode(this.clientNodeAllocateHandler.getServerNode(retryTask.getSceneName(), retryTask.getGroupName(), retryTask.getNamespaceId(), retrySceneConfig.getRouteKey()));
        retryContext.setRetrySceneConfig(retrySceneConfig);
        return retryContext;
    }

    @Override
    protected RetryExecutor<Result<DispatchRetryResultDTO>> builderResultRetryExecutor(RetryContext retryContext, RetrySceneConfig retrySceneConfig) {
        RetryTask retryTask = retryContext.getRetryTask();
        return RetryBuilder.newBuilder().withStopStrategy(StopStrategies.stopException()).withStopStrategy(StopStrategies.stopResultStatusCode()).withWaitStrategy(this.getWaitWaitStrategy(retryTask.getGroupName(), retryTask.getSceneName(), retryTask.getNamespaceId())).withFilterStrategy(FilterStrategies.bitSetIdempotentFilter((IdempotentStrategy<Pair<String, String>, Long>)this.idempotentStrategy)).withFilterStrategy(FilterStrategies.checkAliveClientPodFilter()).withFilterStrategy(FilterStrategies.rebalanceFilterStrategies()).withFilterStrategy(FilterStrategies.rateLimiterFilter()).withRetryContext(retryContext).build();
    }

    @Override
    public TaskExecutorSceneEnum getTaskType() {
        return TaskExecutorSceneEnum.MANUAL_RETRY;
    }

    private WaitStrategy getWaitWaitStrategy(String groupName, String sceneName, String namespaceId) {
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(groupName, sceneName, namespaceId);
        Integer backOff = retrySceneConfig.getBackOff();
        return WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)backOff);
    }

    @Override
    protected boolean preCheck(RetryContext retryContext, RetryExecutor executor) {
        Pair<Boolean, StringBuilder> pair = executor.filter();
        Assert.isTrue((boolean)((Boolean)pair.getKey()), () -> new SnailJobServerException(((StringBuilder)pair.getValue()).toString()));
        return (Boolean)pair.getKey();
    }

    @Override
    protected ActorRef getActorRef() {
        return ActorGenerator.execUnitActor();
    }
}

