/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.result;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailMoreThresholdAlarmEvent;
import com.aizuda.snailjob.server.retry.task.support.handler.CallbackRetryTaskHandler;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="FailureActor")
@Scope(value="prototype")
public class FailureActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(FailureActor.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    private CallbackRetryTaskHandler callbackRetryTaskHandler;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    @Qualifier(value="retryIdempotentStrategyHandler")
    private IdempotentStrategy<Pair<String, String>, Long> idempotentStrategy;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryTask.class, retryTask -> {
            SnailJobLog.LOCAL.debug("FailureActor params:[{}]", new Object[]{retryTask});
            try {
                RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retryTask.getGroupName(), retryTask.getSceneName(), retryTask.getNamespaceId());
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult((RetryTask)retryTask, retrySceneConfig){
                    final /* synthetic */ RetryTask val$retryTask;
                    final /* synthetic */ RetrySceneConfig val$retrySceneConfig;
                    {
                        this.val$retryTask = retryTask;
                        this.val$retrySceneConfig = retrySceneConfig;
                    }

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        Integer maxRetryCount = SyetemTaskTypeEnum.CALLBACK.getType().equals(this.val$retryTask.getTaskType()) ? Integer.valueOf(FailureActor.this.systemProperties.getCallback().getMaxCount()) : this.val$retrySceneConfig.getMaxRetryCount();
                        if (maxRetryCount <= this.val$retryTask.getRetryCount()) {
                            this.val$retryTask.setRetryStatus(RetryStatusEnum.MAX_COUNT.getStatus());
                            FailureActor.this.callbackRetryTaskHandler.create(this.val$retryTask);
                        }
                        this.val$retryTask.setUpdateDt(LocalDateTime.now());
                        Assert.isTrue((1 == FailureActor.this.accessTemplate.getRetryTaskAccess().updateById(this.val$retryTask.getGroupName(), this.val$retryTask.getNamespaceId(), (Object)this.val$retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}] uniqueId:[{}]", new Object[]{this.val$retryTask.getGroupName(), this.val$retryTask.getUniqueId()}));
                        RetryTaskLog retryTaskLog = new RetryTaskLog();
                        retryTaskLog.setRetryStatus(this.val$retryTask.getRetryStatus());
                        FailureActor.this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)this.val$retryTask.getNamespaceId())).eq(RetryTaskLog::getUniqueId, (Object)this.val$retryTask.getUniqueId())).eq(RetryTaskLog::getGroupName, (Object)this.val$retryTask.getGroupName()));
                        FailureActor.this.context.publishEvent((ApplicationEvent)new RetryTaskFailMoreThresholdAlarmEvent(this.val$retryTask));
                    }
                });
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25", new Object[]{e});
            }
            finally {
                this.idempotentStrategy.clear((Object)Pair.of((Object)retryTask.getGroupName(), (Object)retryTask.getNamespaceId()), (Object)retryTask.getId());
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }
}

