/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.log;

import akka.actor.AbstractActor;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.dto.TaskLogFieldDTO;
import com.aizuda.snailjob.server.model.dto.RetryLogTaskDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.dispatch.actor.log.RetryTaskLogDTO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="RetryLogActor")
@Scope(value="prototype")
public class RetryLogActor
extends AbstractActor {
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(List.class, list -> {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            this.saveRetryTaskLogMessage((List<RetryLogTaskDTO>)list);
            this.getContext().stop(this.getSelf());
        }).match(RetryTaskLogDTO.class, retryTaskLogDTO -> {
            this.saveRetryTaskLogMessage((RetryTaskLogDTO)retryTaskLogDTO);
            this.getContext().stop(this.getSelf());
        }).build();
    }

    private void saveRetryTaskLogMessage(List<RetryLogTaskDTO> list) {
        List<RetryLogTaskDTO> jobLogTasks = list;
        Map logTaskDTOMap = jobLogTasks.stream().collect(Collectors.groupingBy(RetryLogTaskDTO::getUniqueId, Collectors.toList()));
        ArrayList<RetryTaskLogMessage> retryTaskLogMessages = new ArrayList<RetryTaskLogMessage>();
        for (List logTaskDTOList : logTaskDTOMap.values()) {
            RetryTaskLogMessage retryTaskLogMessage = RetryTaskConverter.INSTANCE.toRetryTaskLogMessage((RetryLogTaskDTO)logTaskDTOList.get(0));
            retryTaskLogMessage.setCreateDt(LocalDateTime.now());
            retryTaskLogMessage.setLogNum(Integer.valueOf(logTaskDTOList.size()));
            List messageMapList = logTaskDTOList.stream().map(taskDTO -> taskDTO.getFieldList().stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue))).collect(Collectors.toList());
            retryTaskLogMessage.setMessage(JsonUtil.toJsonString(messageMapList));
            retryTaskLogMessages.add(retryTaskLogMessage);
        }
        this.retryTaskLogMessageMapper.insertBatch(retryTaskLogMessages);
    }

    private void saveRetryTaskLogMessage(RetryTaskLogDTO retryTaskLogDTO) {
        RetryTaskLogMessage retryTaskLogMessage = new RetryTaskLogMessage();
        retryTaskLogMessage.setUniqueId(retryTaskLogDTO.getUniqueId());
        retryTaskLogMessage.setGroupName(retryTaskLogDTO.getGroupName());
        retryTaskLogMessage.setNamespaceId(retryTaskLogDTO.getNamespaceId());
        retryTaskLogMessage.setLogNum(Integer.valueOf(1));
        retryTaskLogMessage.setRealTime(retryTaskLogDTO.getRealTime());
        String errorMessage = retryTaskLogDTO.getMessage();
        retryTaskLogMessage.setMessage(StrUtil.isBlank((CharSequence)errorMessage) ? "" : errorMessage);
        retryTaskLogMessage.setCreateDt(Optional.ofNullable(retryTaskLogDTO.getTriggerTime()).orElse(LocalDateTime.now()));
        this.retryTaskLogMessageMapper.insert((Object)retryTaskLogMessage);
    }

    public RetryLogActor(RetryTaskLogMessageMapper retryTaskLogMessageMapper) {
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
    }
}

