/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.enums;

import java.util.Arrays;
import java.util.List;

public enum JobOperationReasonEnum {
    NONE(0, ""),
    TASK_EXECUTION_TIMEOUT(1, "Task execution timeout"),
    NOT_CLIENT(2, "No client nodes"),
    JOB_CLOSED(3, "JOB closed"),
    JOB_DISCARD(4, "Task discarded"),
    JOB_OVERLAY(5, "Task overridden"),
    NOT_EXECUTION_TASK(6, "No executable task items"),
    TASK_EXECUTION_ERROR(7, "Unexpected exception occurred during task execution"),
    MANNER_STOP(8, "Manual stop"),
    WORKFLOW_CONDITION_NODE_EXECUTION_ERROR(9, "Condition node execution exception"),
    JOB_TASK_INTERRUPTED(10, "Task interrupted"),
    WORKFLOW_CALLBACK_NODE_EXECUTION_ERROR(11, "Callback node execution exception"),
    WORKFLOW_NODE_NO_REQUIRED(12, "No action required"),
    WORKFLOW_NODE_CLOSED_SKIP_EXECUTION(13, "Node closed, skipped execution"),
    WORKFLOW_DECISION_FAILED(14, "Judgment not passed");

    private final int reason;
    private final String desc;
    public static final List<Integer> WORKFLOW_SUCCESSOR_SKIP_EXECUTION;

    public static JobOperationReasonEnum getWorkflowNotifyScene(Integer notifyScene) {
        for (JobOperationReasonEnum sceneEnum : JobOperationReasonEnum.values()) {
            if (sceneEnum.getReason() != notifyScene.intValue()) continue;
            return sceneEnum;
        }
        return NONE;
    }

    private JobOperationReasonEnum(int reason, String desc) {
        this.reason = reason;
        this.desc = desc;
    }

    public int getReason() {
        return this.reason;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        WORKFLOW_SUCCESSOR_SKIP_EXECUTION = Arrays.asList(WORKFLOW_NODE_NO_REQUIRED.getReason(), WORKFLOW_DECISION_FAILED.getReason(), WORKFLOW_CONDITION_NODE_EXECUTION_ERROR.getReason());
    }
}

