/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.enums;

import com.aizuda.snailjob.common.core.enums.NodeTypeEnum;

public enum JobNotifySceneEnum {
    NONE(0, "", NodeTypeEnum.SERVER),
    JOB_TASK_ERROR(1, "JOB task execution failed", NodeTypeEnum.SERVER),
    JOB_CLIENT_ERROR(2, "Client execution failed", NodeTypeEnum.CLIENT),
    JOB_NO_CLIENT_NODES_ERROR(3, "No executable client nodes", NodeTypeEnum.SERVER),
    WORKFLOW_TASK_ERROR(100, "Workflow task execution failed", NodeTypeEnum.SERVER);

    private final int notifyScene;
    private final String desc;
    private final NodeTypeEnum nodeType;

    public static JobNotifySceneEnum getJobNotifyScene(int notifyScene, NodeTypeEnum nodeType) {
        for (JobNotifySceneEnum sceneEnum : JobNotifySceneEnum.values()) {
            if (sceneEnum.getNotifyScene() != notifyScene || !sceneEnum.nodeType.getType().equals(nodeType.getType())) continue;
            return sceneEnum;
        }
        return NONE;
    }

    public static JobNotifySceneEnum getJobNotifyScene(Integer notifyScene) {
        for (JobNotifySceneEnum sceneEnum : JobNotifySceneEnum.values()) {
            if (sceneEnum.getNotifyScene() != notifyScene.intValue()) continue;
            return sceneEnum;
        }
        return NONE;
    }

    private JobNotifySceneEnum(int notifyScene, String desc, NodeTypeEnum nodeType) {
        this.notifyScene = notifyScene;
        this.desc = desc;
        this.nodeType = nodeType;
    }

    public int getNotifyScene() {
        return this.notifyScene;
    }

    public String getDesc() {
        return this.desc;
    }

    public NodeTypeEnum getNodeType() {
        return this.nodeType;
    }
}

