/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.enums;

import com.aizuda.snailjob.common.core.exception.SnailJobCommonException;

public enum JobBlockStrategyEnum {
    DISCARD(1),
    OVERLAY(2),
    CONCURRENCY(3),
    RECOVERY(4);

    private final int blockStrategy;

    public static JobBlockStrategyEnum valueOf(int blockStrategy) {
        for (JobBlockStrategyEnum value : JobBlockStrategyEnum.values()) {
            if (value.blockStrategy != blockStrategy) continue;
            return value;
        }
        throw new SnailJobCommonException("Incompatible blocking strategy. blockStrategy:[{}]", (Object)blockStrategy);
    }

    private JobBlockStrategyEnum(int blockStrategy) {
        this.blockStrategy = blockStrategy;
    }

    public int getBlockStrategy() {
        return this.blockStrategy;
    }
}

