/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.rpc;

import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.exception.SnailJobRemotingTimeOutException;
import com.aizuda.snailjob.common.core.model.NettyResult;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.rpc.SnailJobFuture;
import com.aizuda.snailjob.common.log.SnailJobLog;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public final class RpcContext {
    private static final Logger log = LoggerFactory.getLogger(RpcContext.class);
    private static final HashedWheelTimer WHEEL_TIMER = new HashedWheelTimer((ThreadFactory)new CustomizableThreadFactory("snail-job-rpc-timeout-"), 1L, TimeUnit.SECONDS, 1024);
    private static final ConcurrentMap<Long, SnailJobFuture> COMPLETABLE_FUTURE = new ConcurrentHashMap<Long, SnailJobFuture>();

    private RpcContext() {
    }

    public static void invoke(Long requestId, NettyResult nettyResult, boolean timeout) {
        try {
            Optional.ofNullable(COMPLETABLE_FUTURE.remove(requestId)).ifPresent(future -> {
                if (timeout) {
                    future.completeExceptionally(new SnailJobRemotingTimeOutException("Request to remote interface timed out."));
                } else {
                    future.complete(nettyResult);
                }
            });
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u56de\u8c03\u5904\u7406\u5931\u8d25 requestId:[{}]", new Object[]{requestId, e});
        }
    }

    public static <R extends Result<Object>> void setFuture(SnailJobFuture<R> future) {
        if (Objects.nonNull(future)) {
            COMPLETABLE_FUTURE.put(future.getRequestId(), future);
        }
        WHEEL_TIMER.newTimeout((TimerTask)new TimeoutCheckTask(future.getRequestId()), future.getTimeout(), future.getUnit());
    }

    public static class TimeoutCheckTask
    implements TimerTask {
        private final Long requestId;

        public TimeoutCheckTask(Long requestId) {
            this.requestId = requestId;
        }

        public void run(Timeout timeout) throws Exception {
            RpcContext.invoke(this.requestId, new NettyResult(StatusEnum.NO.getStatus(), "Request to remote interface timed out.", null, this.requestId), true);
        }
    }
}

