/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.alarm.strategy;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.attribute.WebhookAttribute;
import com.aizuda.snailjob.common.core.alarm.strategy.AbstractAlarm;
import com.aizuda.snailjob.common.core.enums.AlarmTypeEnum;
import com.aizuda.snailjob.common.core.enums.ContentTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class WebhookAlarm
extends AbstractAlarm<AlarmContext> {
    @Override
    public Integer getAlarmType() {
        return AlarmTypeEnum.WEBHOOK.getValue();
    }

    @Override
    public boolean syncSendMessage(AlarmContext alarmContext) {
        WebhookAttribute webhookAttribute = JsonUtil.parseObject(alarmContext.getNotifyAttribute(), WebhookAttribute.class);
        try {
            WebhookMessage webhookMessage = WebhookMessage.builder().text(alarmContext.getTitle()).build();
            HttpRequest post = HttpUtil.createPost((String)webhookAttribute.getWebhookUrl());
            HttpRequest request = (HttpRequest)post.body(JsonUtil.toJsonString(webhookMessage), ContentTypeEnum.valueOf(webhookAttribute.getContentType()).getMediaType().toString()).header("secret", webhookAttribute.getSecret());
            HttpResponse execute = request.execute();
            SnailJobLog.LOCAL.info("\u53d1\u9001Webhook\u544a\u8b66\u7ed3\u679c. webHook:[{}]\uff0c\u7ed3\u679c: [{}]", new Object[]{webhookAttribute.getWebhookUrl(), execute.body()});
            if (execute.isOk()) {
                return true;
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u53d1\u9001Webhook\u544a\u8b66\u5f02\u5e38. webHook:[{}]", new Object[]{webhookAttribute, e});
            return false;
        }
        return true;
    }

    @Override
    public boolean asyncSendMessage(List<AlarmContext> alarmContexts) {
        for (AlarmContext alarmContext : alarmContexts) {
            this.asyncSendMessage(alarmContext);
        }
        return true;
    }

    private static class WebhookMessage {
        private String text;

        WebhookMessage(String text) {
            this.text = text;
        }

        public static WebhookMessageBuilder builder() {
            return new WebhookMessageBuilder();
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebhookMessage)) {
                return false;
            }
            WebhookMessage other = (WebhookMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WebhookMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "WebhookAlarm.WebhookMessage(text=" + this.getText() + ")";
        }

        public static class WebhookMessageBuilder {
            private String text;

            WebhookMessageBuilder() {
            }

            public WebhookMessageBuilder text(String text) {
                this.text = text;
                return this;
            }

            public WebhookMessage build() {
                return new WebhookMessage(this.text);
            }

            public String toString() {
                return "WebhookAlarm.WebhookMessage.WebhookMessageBuilder(text=" + this.text + ")";
            }
        }
    }
}

