/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.context;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public final class SnailSpringContext {
    private static final Map<String, ContextProvider> providers = new HashMap<String, ContextProvider>();
    private static String activeProvider;
    private static Logger logger;

    private SnailSpringContext() {
    }

    public static void registerProvider(String name, ContextProvider provider) {
        providers.put(name, provider);
        if (activeProvider == null) {
            activeProvider = name;
        }
    }

    public static void setActiveProvider(String name) {
        if (!providers.containsKey(name)) {
            throw new IllegalArgumentException("No provider registered with name: " + name);
        }
        activeProvider = name;
    }

    private static ContextProvider getActiveProvider() {
        if (activeProvider == null || !providers.containsKey(activeProvider)) {
            throw new IllegalStateException("No active context provider registered. Please register a provider using SnailContext.registerProvider()");
        }
        return providers.get(activeProvider);
    }

    public static <T> T getBeanByType(Class<T> clazz) {
        return SnailSpringContext.getBean(clazz);
    }

    public static <T> T getBean(String name) {
        try {
            return SnailSpringContext.getActiveProvider().getBean(name);
        }
        catch (Exception exception) {
            logger.error("BeanName:{} not exist\uff0cException => {}", name, exception.getMessage());
            return null;
        }
    }

    public static <T> T getBean(Class<T> requiredType) {
        try {
            return SnailSpringContext.getActiveProvider().getBean(requiredType);
        }
        catch (Exception exception) {
            logger.error("BeanType:{} not exist\uff0cException => {}", requiredType.getName(), exception.getMessage());
            return null;
        }
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        try {
            return SnailSpringContext.getActiveProvider().getBean(name, requiredType);
        }
        catch (Exception exception) {
            logger.error("BeanName:{} not exist\uff0cException => {}", name, exception.getMessage());
            return null;
        }
    }

    public static ApplicationContext getContext() {
        try {
            return SnailSpringContext.getActiveProvider().getContext();
        }
        catch (Exception exception) {
            logger.error("BeanName:{} not exist\uff0cException => {}", exception.getMessage());
            return null;
        }
    }

    public static void publishEvent(ApplicationEvent applicationEvent) {
        try {
            SnailSpringContext.getActiveProvider().publishEvent(applicationEvent);
        }
        catch (Exception exception) {
            logger.error("BeanName:{} not exist\uff0cException => {}", exception.getMessage());
        }
    }

    public static void publishEvent(Object event) {
        try {
            SnailSpringContext.getActiveProvider().publishEvent(event);
        }
        catch (Exception exception) {
            logger.error("BeanName:{} not exist\uff0cException => {}", exception.getMessage());
        }
    }

    @Generated
    public static void setLogger(Logger logger) {
        SnailSpringContext.logger = logger;
    }

    static {
        logger = new DefaultLogger();
    }

    public static interface ContextProvider {
        public <T> T getBean(String var1);

        public <T> T getBean(Class<T> var1);

        public <T> T getBean(String var1, Class<T> var2);

        public ApplicationContext getContext() throws Exception;

        public void publishEvent(ApplicationEvent var1);

        public void publishEvent(Object var1);
    }

    public static interface Logger {
        public void error(String var1, Object ... var2);
    }

    private static class DefaultLogger
    implements Logger {
        private DefaultLogger() {
        }

        @Override
        public void error(String message, Object ... args) {
            System.err.printf("[ERROR] " + message + "%n", args);
        }
    }
}

