/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.report;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.window.SlidingRingWindow;
import com.aizuda.snailjob.client.core.report.AbstractReport;
import com.aizuda.snailjob.client.core.report.ReportListener;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.common.core.window.Listener;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.RetryTaskRequest;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class AsyncReport
extends AbstractReport
implements Lifecycle {
    private SlidingRingWindow<RetryTaskRequest> slidingWindow;

    @Override
    public boolean supports(boolean async) {
        return async;
    }

    @Override
    public boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        return this.syncReport(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params, retryerInfo.getTimeout(), retryerInfo.getUnit());
    }

    public Boolean syncReport(String scene, String targetClassName, Object[] args, long timeout, TimeUnit unit) {
        RetryTaskRequest retryTaskRequest = this.buildRetryTaskDTO(scene, targetClassName, args);
        this.slidingWindow.add((Object)retryTaskRequest);
        return Boolean.TRUE;
    }

    public void start() {
        SnailJobProperties.SlidingWindowConfig slidingWindowConfig = this.snailJobProperties.getRetry().getReportSlidingWindow();
        ChronoUnit chronoUnit = slidingWindowConfig.getChronoUnit();
        Duration duration = Duration.of(slidingWindowConfig.getDuration(), chronoUnit);
        this.slidingWindow = new SlidingRingWindow(duration, Integer.valueOf(slidingWindowConfig.getTotalThreshold()), (List)Lists.newArrayList((Object[])new Listener[]{new ReportListener()}));
    }

    public void close() {
        SnailJobLog.LOCAL.info("AsyncReport about to shutdown", new Object[0]);
        if (Objects.nonNull(this.slidingWindow)) {
            this.slidingWindow.shutdown();
        }
        SnailJobLog.LOCAL.info("AsyncReport has been shutdown", new Object[0]);
    }
}

