/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.intercepter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.core.MethodResult;
import com.aizuda.snailjob.client.core.RetryCondition;
import com.aizuda.snailjob.client.core.annotation.Propagation;
import com.aizuda.snailjob.client.core.annotation.Retryable;
import com.aizuda.snailjob.client.core.cache.RetryerInfoCache;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.client.core.retryer.RetryerResultContext;
import com.aizuda.snailjob.client.core.strategy.RetryStrategy;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.RetryResultStatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.ConfigRequest;
import com.google.common.base.Defaults;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.ClassUtils;
import org.springframework.aop.AfterAdvice;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class SnailRetryInterceptor
implements MethodInterceptor,
AfterAdvice,
Serializable,
Ordered {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String retryErrorMoreThresholdTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u91cd\u8bd5\u7ec4\u4ef6\u5f02\u5e38</font>  \n> IP:{}  \n> \u7a7a\u95f4ID:{}  \n> \u540d\u79f0:{}  \n> \u65f6\u95f4:{}  \n> \u5f02\u5e38:{}  \n";
    private final RetryStrategy retryStrategy;
    private final int order;

    public SnailRetryInterceptor(int order, RetryStrategy localRetryStrategies) {
        this.order = order;
        this.retryStrategy = localRetryStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        RetryerResultContext retryerResultContext;
        String traceId = UUID.randomUUID().toString();
        SnailJobLog.LOCAL.debug("Start entering the around method traceId:[{}]", new Object[]{traceId});
        Retryable retryable = this.getAnnotationParameter(invocation.getMethod());
        String executorClassName = invocation.getThis().getClass().getName();
        String methodEntrance = this.getMethodEntrance(retryable, executorClassName);
        if (Propagation.REQUIRES_NEW.equals((Object)retryable.propagation())) {
            if (!RetrySiteSnapshot.isMethodEntrance(methodEntrance)) {
                if (RetrySiteSnapshot.isRunning() && RetrySiteSnapshot.getStage().intValue() == RetrySiteSnapshot.EnumStage.LOCAL.getStage()) {
                    RetrySiteSnapshot.suspend();
                    RetrySiteSnapshot.removeAll();
                }
                RetrySiteSnapshot.setMethodEntrance(methodEntrance);
            }
        } else if (!RetrySiteSnapshot.existedMethodEntrance()) {
            RetrySiteSnapshot.setMethodEntrance(methodEntrance);
        } else {
            SnailJobLog.LOCAL.debug("No need to set entrance signs:[{}]", new Object[]{traceId});
        }
        Throwable throwable = null;
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (Throwable t) {
            try {
                throwable = t;
            }
            catch (Throwable throwable2) {
                SnailJobLog.LOCAL.debug("Start retrying. traceId:[{}] scene:[{}] executorClassName:[{}]", new Object[]{traceId, retryable.scene(), executorClassName});
                RetryerResultContext retryerResultContext2 = this.doHandlerRetry(invocation, traceId, retryable, executorClassName, methodEntrance, throwable, result);
                throw throwable2;
            }
            SnailJobLog.LOCAL.debug("Start retrying. traceId:[{}] scene:[{}] executorClassName:[{}]", new Object[]{traceId, retryable.scene(), executorClassName});
            retryerResultContext = this.doHandlerRetry(invocation, traceId, retryable, executorClassName, methodEntrance, throwable, result);
        }
        SnailJobLog.LOCAL.debug("Start retrying. traceId:[{}] scene:[{}] executorClassName:[{}]", new Object[]{traceId, retryable.scene(), executorClassName});
        retryerResultContext = this.doHandlerRetry(invocation, traceId, retryable, executorClassName, methodEntrance, throwable, result);
        SnailJobLog.LOCAL.debug("Method return value is [{}]. traceId:[{}]", new Object[]{result, traceId, throwable});
        if (Objects.nonNull(retryerResultContext)) {
            if (retryerResultContext.getRetryResultStatusEnum().getStatus().equals(RetryResultStatusEnum.SUCCESS.getStatus())) {
                return retryerResultContext.getResult();
            }
            if (!retryable.isThrowException() && Objects.nonNull(throwable)) {
                return SnailRetryInterceptor.retryFailHandle(invocation, retryable, executorClassName, throwable, traceId, retryerResultContext);
            }
        }
        if (RetrySiteSnapshot.isMethodEntrance(methodEntrance) && !RetrySiteSnapshot.isRunning()) {
            RetrySiteSnapshot.removeSuspend();
            RetrySiteSnapshot.removeAll();
        }
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    private boolean retryIfResult(Object result, Retryable retryable, String traceId, String executorClassName) {
        try {
            Class<? extends RetryCondition> retryConditionClass = retryable.retryIfResult();
            if (Objects.nonNull(retryConditionClass) && !retryConditionClass.isAssignableFrom(RetryCondition.NoRetry.class)) {
                RetryCondition retryCondition = retryConditionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return retryCondition.shouldRetry(result);
            }
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.debug("Retry condition fail. traceId:[{}] scene:[{}] executorClassName:[{}]", new Object[]{traceId, retryable.scene(), executorClassName});
        }
        return false;
    }

    private static Object retryFailHandle(MethodInvocation invocation, Retryable retryable, String executorClassName, Throwable throwable, String traceId, RetryerResultContext retryerResultContext) {
        Method method = invocation.getMethod();
        try {
            Class<? extends MethodResult> methodResultClass = retryable.methodResult();
            if (Objects.nonNull(methodResultClass) && !methodResultClass.isAssignableFrom(MethodResult.NoMethodResult.class)) {
                MethodResult methodResult = methodResultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object resultObj = methodResult.result(retryable.scene(), executorClassName, invocation.getArguments(), throwable);
                Class returnType = ClassUtils.primitiveToWrapper(method.getReturnType());
                if (Objects.nonNull(resultObj) && returnType.isAssignableFrom(resultObj.getClass())) {
                    return resultObj;
                }
            }
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.debug("Get method result is error. traceId:[{}] scene:[{}] executorClassName:[{}]", new Object[]{traceId, retryable.scene(), executorClassName, throwable});
        }
        if (Objects.isNull(retryerResultContext.getResult()) && method.getReturnType().isPrimitive()) {
            return Defaults.defaultValue(method.getReturnType());
        }
        return retryerResultContext.getResult();
    }

    private RetryerResultContext doHandlerRetry(MethodInvocation invocation, String traceId, Retryable retryable, String executorClassName, String methodEntrance, Throwable throwable, Object result) {
        if (!RetrySiteSnapshot.isMethodEntrance(methodEntrance) || RetrySiteSnapshot.isRunning() || Objects.isNull(throwable) && !this.retryIfResult(result, retryable, traceId, executorClassName) || RetrySiteSnapshot.isRetryFlow() || RetrySiteSnapshot.isRetryForStatusCode() || !this.retryIfException(throwable, RetryerInfoCache.get(retryable.scene(), executorClassName))) {
            if (!RetrySiteSnapshot.isMethodEntrance(methodEntrance)) {
                SnailJobLog.LOCAL.debug("Non-method entry does not enable local retries. traceId:[{}] [{}]", new Object[]{traceId, RetrySiteSnapshot.getMethodEntrance()});
            } else if (RetrySiteSnapshot.isRunning()) {
                SnailJobLog.LOCAL.debug("Existing running retry tasks do not enable local retries. traceId:[{}] [{}]", new Object[]{traceId, RetrySiteSnapshot.EnumStage.valueOfStage(RetrySiteSnapshot.getStage())});
            } else if (Objects.isNull(throwable)) {
                SnailJobLog.LOCAL.debug("No exception, no local retries. traceId:[{}]", new Object[]{traceId});
            } else if (RetrySiteSnapshot.isRetryFlow()) {
                SnailJobLog.LOCAL.debug("Retry traffic does not enable local retries. traceId:[{}] [{}]", new Object[]{traceId, RetrySiteSnapshot.getRetryHeader()});
            } else if (RetrySiteSnapshot.isRetryForStatusCode()) {
                SnailJobLog.LOCAL.debug("Existing exception retry codes do not enable local retries. traceId:[{}]", new Object[]{traceId});
            } else if (!this.retryIfException(throwable, RetryerInfoCache.get(retryable.scene(), executorClassName))) {
                SnailJobLog.LOCAL.debug("Exception mismatch. traceId:[{}]", new Object[]{traceId});
            } else {
                SnailJobLog.LOCAL.debug("Unknown situations do not enable local retry scenarios. traceId:[{}]", new Object[]{traceId});
            }
            return null;
        }
        return this.openRetry(invocation, traceId, retryable, executorClassName, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetryerResultContext openRetry(MethodInvocation point, String traceId, Retryable retryable, String executorClassName, Throwable throwable) {
        try {
            this.initHeaders(retryable);
            RetryerResultContext context = this.retryStrategy.openRetry(retryable.scene(), executorClassName, point.getArguments());
            if (RetryResultStatusEnum.SUCCESS.getStatus().equals(context.getRetryResultStatusEnum().getStatus())) {
                SnailJobLog.LOCAL.debug("local retry successful. traceId:[{}] result:[{}]", new Object[]{traceId, context.getResult()});
            } else {
                SnailJobLog.LOCAL.debug("local retry result. traceId:[{}] throwable:[{}]", new Object[]{traceId, context.getThrowable()});
            }
            RetryerResultContext retryerResultContext = context;
            return retryerResultContext;
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("retry component handling exception\uff0ctraceId:[{}]", new Object[]{traceId, e});
            this.sendMessage(e);
        }
        finally {
            RetrySiteSnapshot.removeAll();
            RetrySiteSnapshot.restore();
        }
        return null;
    }

    private void initHeaders(Retryable retryable) {
        SnailJobHeaders snailJobHeaders = new SnailJobHeaders();
        snailJobHeaders.setRetry(Boolean.TRUE.booleanValue());
        snailJobHeaders.setRetryId(IdUtil.getSnowflakeNextIdStr());
        snailJobHeaders.setDdl(GroupVersionCache.getDdl((String)retryable.scene()));
        RetrySiteSnapshot.setRetryHeader(snailJobHeaders);
    }

    private void sendMessage(Exception e) {
        try {
            ConfigRequest.Notify notify = GroupVersionCache.getRetryNotifyAttribute((Integer)RetryNotifySceneEnum.CLIENT_COMPONENT_ERROR.getNotifyScene());
            if (Objects.nonNull(notify)) {
                SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
                if (Objects.isNull(snailJobProperties)) {
                    return;
                }
                List recipients = Optional.ofNullable(notify.getRecipients()).orElse(Lists.newArrayList());
                for (ConfigRequest.Notify.Recipient recipient : recipients) {
                    AlarmContext context = AlarmContext.build().text(retryErrorMoreThresholdTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), snailJobProperties.getNamespace(), snailJobProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("retry component handling exception:[{}]", new Object[]{snailJobProperties.getGroup()}).notifyAttribute(recipient.getNotifyAttribute());
                    Optional.ofNullable(SnailJobAlarmFactory.getAlarmType((Integer)recipient.getNotifyType())).ifPresent(alarm -> alarm.asyncSendMessage((Object)context));
                }
            }
        }
        catch (Exception e1) {
            SnailJobLog.LOCAL.error("Client failed to send component exception alert.", new Object[]{e1});
        }
    }

    public String getMethodEntrance(Retryable retryable, String executorClassName) {
        if (Objects.isNull(retryable)) {
            return "";
        }
        return retryable.scene().concat("_").concat(executorClassName);
    }

    private Retryable getAnnotationParameter(Method method) {
        Retryable retryable = null;
        if (method.isAnnotationPresent(Retryable.class)) {
            retryable = method.getAnnotation(Retryable.class);
        }
        if (retryable == null) {
            retryable = (Retryable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Retryable.class);
        }
        return retryable;
    }

    public int getOrder() {
        return this.order;
    }

    private boolean retryIfException(Throwable throwable, RetryerInfo retryerInfo) {
        Set<Class<? extends Throwable>> exclude = retryerInfo.getExclude();
        Set<Class<? extends Throwable>> include = retryerInfo.getInclude();
        if (CollUtil.isEmpty(include) && CollUtil.isEmpty(exclude)) {
            return true;
        }
        for (Class<? extends Throwable> e : include) {
            if (!e.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        if (CollUtil.isNotEmpty(exclude)) {
            for (Class<? extends Throwable> e : exclude) {
                if (!e.isAssignableFrom(throwable.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

