/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.executor;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.core.RetryCondition;
import com.aizuda.snailjob.client.core.RetryExecutorParameter;
import com.aizuda.snailjob.client.core.cache.RetryerInfoCache;
import com.aizuda.snailjob.client.core.exception.RetryIfResultException;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.executor.AbstractRetryExecutor;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategy;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaRetryExecutor
extends AbstractRetryExecutor<WaitStrategy, StopStrategy> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GuavaRetryExecutor.class);

    public GuavaRetryExecutor(String sceneName, String executorClassName) {
        this.retryerInfo = RetryerInfoCache.get(sceneName, executorClassName);
        Assert.notNull((Object)this.retryerInfo, () -> new SnailRetryClientException("retryerInfo is null sceneName:[{}] executorClassName:[{}]", sceneName, executorClassName));
    }

    public GuavaRetryExecutor() {
    }

    @Override
    public Retryer build(RetryExecutorParameter<WaitStrategy, StopStrategy> parameter) {
        RetryerBuilder retryerBuilder = RetryerBuilder.newBuilder();
        retryerBuilder.retryIfException(throwable -> true);
        if (Objects.nonNull(this.retryerInfo) && !this.retryerInfo.getRetryCondition().isAssignableFrom(RetryCondition.NoRetry.class)) {
            retryerBuilder.retryIfResult(this::retryIf);
        }
        retryerBuilder.withWaitStrategy(parameter.backOff());
        retryerBuilder.withStopStrategy(parameter.stop());
        for (RetryListener retryListener : parameter.getRetryListeners()) {
            retryerBuilder.withRetryListener(retryListener);
        }
        return retryerBuilder.build();
    }

    @Override
    public <V> V call(Retryer<V> retryer, Callable<V> callable, Consumer<Throwable> retryError, Consumer<V> retrySuccess) throws Exception {
        Object result = null;
        try {
            result = retryer.call(callable);
            retrySuccess.accept(result);
        }
        catch (RetryException e) {
            Attempt attempt = e.getLastFailedAttempt();
            if (attempt.hasException()) {
                retryError.accept(e.getLastFailedAttempt().getExceptionCause());
                SnailJobLog.LOCAL.debug("Business system retry exception:", new Object[]{e.getLastFailedAttempt().getExceptionCause()});
            }
            SnailJobLog.LOCAL.debug("Business system retry exception:", new Object[]{e.getLastFailedAttempt().getResult()});
            retryError.accept((Throwable)((Object)new RetryIfResultException("Business system retry exception. result: {}", e.getLastFailedAttempt().getResult())));
        }
        return (V)result;
    }

    private boolean retryIf(Object result) {
        try {
            Class<? extends RetryCondition> retryConditionClass = this.retryerInfo.getRetryCondition();
            RetryCondition retryCondition = retryConditionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return retryCondition.shouldRetry(result);
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.error("Retry condition fail. scene:[{}] executorClassName:[{}]", new Object[]{this.retryerInfo.getScene(), this.retryerInfo.getExecutorClassName(), e});
            return false;
        }
    }
}

