/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.client;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.annotation.Mapping;
import com.aizuda.snailjob.client.common.annotation.SnailEndPoint;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.common.rpc.client.RequestMethod;
import com.aizuda.snailjob.client.core.IdempotentIdGenerate;
import com.aizuda.snailjob.client.core.RetryArgSerializer;
import com.aizuda.snailjob.client.core.cache.FutureCache;
import com.aizuda.snailjob.client.core.cache.RetryerInfoCache;
import com.aizuda.snailjob.client.core.callback.future.CallbackTaskExecutorFutureCallback;
import com.aizuda.snailjob.client.core.callback.future.RetryTaskExecutorFutureCallback;
import com.aizuda.snailjob.client.core.context.CallbackContext;
import com.aizuda.snailjob.client.core.context.RemoteRetryContext;
import com.aizuda.snailjob.client.core.exception.RetryArgSerializeException;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.executor.RemoteCallbackExecutor;
import com.aizuda.snailjob.client.core.executor.RemoteRetryExecutor;
import com.aizuda.snailjob.client.core.loader.SnailRetrySpiLoader;
import com.aizuda.snailjob.client.core.log.RetryLogMeta;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.client.core.timer.StopTaskTimerTask;
import com.aizuda.snailjob.client.core.timer.TimerManager;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.IdempotentIdContext;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.model.request.DispatchRetryRequest;
import com.aizuda.snailjob.model.request.GenerateRetryIdempotentIdRequest;
import com.aizuda.snailjob.model.request.RetryArgsDeserializeRequest;
import com.aizuda.snailjob.model.request.RetryCallbackRequest;
import com.aizuda.snailjob.model.request.StopRetryRequest;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.validation.Valid;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;

@SnailEndPoint
@Validated
public class SnailRetryEndPoint
implements Lifecycle {
    private final RemoteRetryExecutor remoteRetryExecutor;
    private final RemoteCallbackExecutor remoteCallbackExecutor;
    private final SnailJobProperties snailJobProperties;
    private ThreadPoolExecutor dispatcherThreadPool = null;

    @Mapping(path="/retry/dispatch/v1", method=RequestMethod.POST)
    public Result<Boolean> dispatch(@Valid DispatchRetryRequest request) {
        Object[] deSerialize;
        RemoteRetryContext retryContext = SnailRetryEndPoint.bulidRemoteRetryContext(request);
        RetryerInfo retryerInfo = RetryerInfoCache.get(request.getSceneName(), request.getExecutorName());
        if (Objects.isNull(retryerInfo)) {
            SnailJobLog.REMOTE.error("Scene [{}] configuration does not exist, please check if your scene and executor exist", new Object[]{request.getSceneName()});
            return new Result(StatusEnum.NO.getStatus().intValue(), MessageFormat.format("Scene [{0}] configuration does not exist, please check if your scene and executor exist", request.getSceneName()));
        }
        SnailRetryEndPoint.initLogContext(retryContext);
        RetryArgSerializer retryArgSerializer = SnailRetrySpiLoader.loadRetryArgSerializer(request.getSerializerName());
        try {
            deSerialize = (Object[])retryArgSerializer.deSerialize(request.getArgsStr(), retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
        }
        catch (RetryArgSerializeException e) {
            SnailJobLog.REMOTE.error("Parameter parsing exception args:[{}]", new Object[]{request.getArgsStr(), e});
            return new Result(StatusEnum.NO.getStatus().intValue(), MessageFormat.format("Parameter parsing exception args:[{0}]", request.getArgsStr()));
        }
        retryContext.setDeSerialize(deSerialize);
        ListeningExecutorService decorator = MoreExecutors.listeningDecorator((ExecutorService)this.dispatcherThreadPool);
        ListenableFuture submit = decorator.submit(() -> this.remoteRetryExecutor.doRetry(retryContext));
        FutureCache.addFuture(request.getRetryTaskId(), submit);
        Futures.addCallback((ListenableFuture)submit, (FutureCallback)new RetryTaskExecutorFutureCallback(retryContext), (Executor)decorator);
        TimerManager.add(new StopTaskTimerTask(request.getRetryTaskId()), request.getExecutorTimeout().intValue(), TimeUnit.SECONDS);
        SnailJobLog.REMOTE.info(" Retry task:[{}] scheduled successfully.", new Object[]{request.getRetryTaskId()});
        return new Result((Object)Boolean.TRUE);
    }

    private static RemoteRetryContext bulidRemoteRetryContext(DispatchRetryRequest request) {
        RemoteRetryContext retryContext = new RemoteRetryContext();
        retryContext.setRetryTaskId(request.getRetryTaskId());
        retryContext.setRetryId(request.getRetryId());
        retryContext.setRetryCount(request.getRetryCount());
        retryContext.setArgsStr(request.getArgsStr());
        retryContext.setGroupName(request.getGroupName());
        retryContext.setNamespaceId(request.getNamespaceId());
        retryContext.setScene(request.getSceneName());
        retryContext.setExecutorName(request.getExecutorName());
        return retryContext;
    }

    private static void initLogContext(RemoteRetryContext context) {
        RetryLogMeta retryLogMeta = new RetryLogMeta();
        retryLogMeta.setGroupName(context.getGroupName());
        retryLogMeta.setNamespaceId(context.getNamespaceId());
        retryLogMeta.setRetryId(context.getRetryId());
        retryLogMeta.setRetryTaskId(context.getRetryTaskId());
        SnailJobLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
    }

    @Mapping(path="/retry/callback/v1", method=RequestMethod.POST)
    public Result<Boolean> callback(@Valid RetryCallbackRequest callbackDTO) {
        CallbackContext callbackContext = SnailRetryEndPoint.buildCallbackContext(callbackDTO);
        try {
            SnailRetryEndPoint.initLogContext(callbackContext);
            RetryerInfo retryerInfo = RetryerInfoCache.get(callbackDTO.getSceneName(), callbackDTO.getExecutorName());
            if (Objects.isNull(retryerInfo)) {
                SnailJobLog.REMOTE.error("Scene [{}] configuration does not exist, please check if your scene and executor exist", new Object[]{callbackDTO.getSceneName()});
                return new Result(0, "Callback failed", (Object)Boolean.FALSE);
            }
            RetryArgSerializer retryArgSerializer = SnailRetrySpiLoader.loadRetryArgSerializer(callbackDTO.getSerializerName());
            Object[] deSerialize = (Object[])retryArgSerializer.deSerialize(callbackDTO.getArgsStr(), retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
            callbackContext.setDeSerialize(deSerialize);
            callbackContext.setRetryerInfo(retryerInfo);
        }
        catch (RetryArgSerializeException e) {
            SnailJobLog.REMOTE.error("Parameter parsing exception", new Object[]{e});
            return new Result(0, "Callback failed", (Object)Boolean.FALSE);
        }
        ListeningExecutorService decorator = MoreExecutors.listeningDecorator((ExecutorService)this.dispatcherThreadPool);
        ListenableFuture submit = decorator.submit(() -> {
            this.remoteCallbackExecutor.doRetryCallback(callbackContext);
            return Boolean.TRUE;
        });
        FutureCache.addFuture(callbackDTO.getRetryTaskId(), submit);
        Futures.addCallback((ListenableFuture)submit, (FutureCallback)new CallbackTaskExecutorFutureCallback(callbackContext), (Executor)decorator);
        TimerManager.add(new StopTaskTimerTask(callbackDTO.getRetryTaskId()), callbackDTO.getExecutorTimeout().intValue(), TimeUnit.SECONDS);
        SnailJobLog.REMOTE.info(" Callback task:[{}] scheduled successfully.", new Object[]{callbackDTO.getRetryTaskId()});
        return new Result((Object)Boolean.TRUE);
    }

    private static CallbackContext buildCallbackContext(RetryCallbackRequest callbackDTO) {
        CallbackContext callbackContext = new CallbackContext();
        callbackContext.setRetryTaskId(callbackDTO.getRetryTaskId());
        callbackContext.setRetryId(callbackDTO.getRetryId());
        callbackContext.setGroupName(callbackDTO.getGroupName());
        callbackContext.setNamespaceId(callbackDTO.getNamespaceId());
        callbackContext.setSceneName(callbackDTO.getSceneName());
        callbackContext.setRetryStatus(callbackDTO.getRetryStatus());
        return callbackContext;
    }

    private static void initLogContext(CallbackContext context) {
        RetryLogMeta retryLogMeta = new RetryLogMeta();
        retryLogMeta.setGroupName(context.getGroupName());
        retryLogMeta.setNamespaceId(context.getNamespaceId());
        retryLogMeta.setRetryTaskId(context.getRetryTaskId());
        retryLogMeta.setRetryId(context.getRetryId());
        SnailJobLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
    }

    @Mapping(path="/retry/generate/idempotent-id/v1", method=RequestMethod.POST)
    public Result<String> idempotentIdGenerate(@Valid GenerateRetryIdempotentIdRequest generateRetryIdempotentIdRequest) {
        String idempotentId;
        String scene = generateRetryIdempotentIdRequest.getScene();
        String executorName = generateRetryIdempotentIdRequest.getExecutorName();
        String argsStr = generateRetryIdempotentIdRequest.getArgsStr();
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, executorName);
        Assert.notNull((Object)retryerInfo, () -> new SnailRetryClientException("Retry information does not exist for scene:[{}] executorName:[{}]", scene, executorName));
        Method executorMethod = retryerInfo.getMethod();
        RetryArgSerializer retryArgSerializer = SnailRetrySpiLoader.loadRetryArgSerializer(generateRetryIdempotentIdRequest.getSerializerName());
        Object[] deSerialize = null;
        try {
            deSerialize = (Object[])retryArgSerializer.deSerialize(argsStr, retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
        }
        catch (RetryArgSerializeException e) {
            throw new SnailRetryClientException("Parameter parsing exception", (Throwable)((Object)e));
        }
        try {
            Class<? extends IdempotentIdGenerate> idempotentIdGenerate = retryerInfo.getIdempotentIdGenerate();
            IdempotentIdGenerate generate = idempotentIdGenerate.newInstance();
            Method method = idempotentIdGenerate.getMethod("idGenerate", IdempotentIdContext.class);
            IdempotentIdContext idempotentIdContext = new IdempotentIdContext(scene, executorName, deSerialize, executorMethod.getName(), argsStr);
            idempotentId = (String)ReflectionUtils.invokeMethod((Method)method, (Object)generate, (Object[])new Object[]{idempotentIdContext});
        }
        catch (Exception exception) {
            SnailJobLog.LOCAL.error("Idempotent ID generation exception: {}, {}", new Object[]{scene, argsStr, exception});
            throw new SnailRetryClientException("idempotentId generation exception: {}, {}", scene, argsStr);
        }
        return new Result((Object)idempotentId);
    }

    @Mapping(path="/retry/deserialize/args/v1", method=RequestMethod.POST)
    public Result<Object> deserialize(@Valid RetryArgsDeserializeRequest retryDeserializeRequest) {
        Object result;
        String scene = retryDeserializeRequest.getScene();
        String executorName = retryDeserializeRequest.getExecutorName();
        String argsStr = retryDeserializeRequest.getArgsStr();
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, executorName);
        RetryArgSerializer retryArgSerializer = SnailRetrySpiLoader.loadRetryArgSerializer(retryDeserializeRequest.getSerializerName());
        try {
            result = retryArgSerializer.deSerialize(argsStr, retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
        }
        catch (RetryArgSerializeException e) {
            throw new SnailRetryClientException("Parameter parsing exception", (Throwable)((Object)e));
        }
        return new Result(result);
    }

    @Mapping(path="/retry/stop/v1", method=RequestMethod.POST)
    public Result<Boolean> stop(@Valid StopRetryRequest stopRetryRequest) {
        FutureCache.remove(stopRetryRequest.getRetryTaskId());
        return new Result((Object)Boolean.TRUE);
    }

    public void start() {
        if (Objects.nonNull(this.dispatcherThreadPool)) {
            return;
        }
        SnailJobProperties.ThreadPoolConfig threadPoolConfig = this.snailJobProperties.getRetry().getDispatcherThreadPool();
        this.dispatcherThreadPool = new ThreadPoolExecutor(threadPoolConfig.getCorePoolSize(), threadPoolConfig.getMaximumPoolSize(), threadPoolConfig.getKeepAliveTime(), threadPoolConfig.getTimeUnit(), new LinkedBlockingQueue<Runnable>(threadPoolConfig.getQueueCapacity()), (ThreadFactory)new CustomizableThreadFactory("snail-retry-dispatcher-"));
    }

    public void close() {
        if (Objects.nonNull(this.dispatcherThreadPool)) {
            this.dispatcherThreadPool.shutdown();
        }
    }

    @Generated
    public SnailRetryEndPoint(RemoteRetryExecutor remoteRetryExecutor, RemoteCallbackExecutor remoteCallbackExecutor, SnailJobProperties snailJobProperties) {
        this.remoteRetryExecutor = remoteRetryExecutor;
        this.remoteCallbackExecutor = remoteCallbackExecutor;
        this.snailJobProperties = snailJobProperties;
    }
}

