/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.plugin;

import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderPlugins {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderPlugins.class);

    private RequestHeaderPlugins() {
    }

    public static Map<String, String> requestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        SnailJobHeaders retryHeader = RetrySiteSnapshot.getRetryHeader();
        if (Objects.nonNull(retryHeader)) {
            long callRemoteTime = System.currentTimeMillis();
            Long entryMethodTime = RetrySiteSnapshot.getEntryMethodTime();
            if (Objects.isNull(entryMethodTime)) {
                SnailJobLog.LOCAL.warn("entry method time is null. retryId:[{}]", new Object[]{retryHeader.getRetryId()});
            } else {
                long transmitTime = retryHeader.getDdl() - (callRemoteTime - entryMethodTime);
                SnailJobLog.LOCAL.info("RPC passes header: callRemoteTime:[{}] - entryMethodTime:[{}] = transmitTime:[{}]", new Object[]{callRemoteTime, entryMethodTime, transmitTime});
                if (transmitTime > 0L) {
                    retryHeader.setDdl(transmitTime);
                    RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
                } else {
                    throw new SnailRetryClientException("The call chain has timed out, no further requests will be made");
                }
            }
            header.put("snail-job", JsonUtil.toJsonString((Object)retryHeader));
        }
        return header;
    }
}

