/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.loader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ServiceLoaderUtil;
import com.aizuda.snailjob.client.core.RetryArgSerializer;
import com.aizuda.snailjob.client.core.RetrySiteSnapshotContext;
import com.aizuda.snailjob.client.core.event.SimpleSnailRetryListener;
import com.aizuda.snailjob.client.core.event.SnailJobListener;
import com.aizuda.snailjob.client.core.expression.ExpressionInvocationHandler;
import com.aizuda.snailjob.client.core.intercepter.ThreadLockRetrySiteSnapshotContext;
import com.aizuda.snailjob.client.core.serializer.FurySerializer;
import com.aizuda.snailjob.common.core.expression.ExpressionEngine;
import com.aizuda.snailjob.common.core.expression.ExpressionFactory;
import com.aizuda.snailjob.common.core.expression.strategy.SpELExpressionEngine;
import java.lang.reflect.InvocationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SnailRetrySpiLoader {
    private SnailRetrySpiLoader() {
    }

    public static RetryArgSerializer loadRetryArgSerializer() {
        return Optional.ofNullable((RetryArgSerializer)ServiceLoaderUtil.loadFirst(RetryArgSerializer.class)).orElse(new FurySerializer());
    }

    public static RetryArgSerializer loadRetryArgSerializer(String name) {
        return ServiceLoaderUtil.loadList(RetryArgSerializer.class).stream().filter(retryArgSerializer -> retryArgSerializer.name().equals(name)).findAny().orElse(new FurySerializer());
    }

    public static List<SnailJobListener> loadSnailJobListener() {
        List snailJobListeners = ServiceLoaderUtil.loadList(SnailJobListener.class);
        if (CollUtil.isEmpty((Collection)snailJobListeners)) {
            return Collections.singletonList(new SimpleSnailRetryListener());
        }
        return snailJobListeners;
    }

    public static <T> RetrySiteSnapshotContext<T> loadRetrySiteSnapshotContext() {
        return Optional.ofNullable((RetrySiteSnapshotContext)ServiceLoaderUtil.loadFirst(RetrySiteSnapshotContext.class)).orElse(new ThreadLockRetrySiteSnapshotContext(new ThreadLocal()));
    }

    public static ExpressionEngine loadExpressionEngine() {
        ExpressionEngine expressionEngine = Optional.ofNullable((ExpressionEngine)ServiceLoaderUtil.loadFirst(ExpressionEngine.class)).orElse((ExpressionEngine)new SpELExpressionEngine());
        return ExpressionFactory.getExpressionEngine((InvocationHandler)new ExpressionInvocationHandler(expressionEngine));
    }
}

