/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.report;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.core.IdempotentIdGenerate;
import com.aizuda.snailjob.client.core.Report;
import com.aizuda.snailjob.client.core.RetryArgSerializer;
import com.aizuda.snailjob.client.core.cache.RetryerInfoCache;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.client.core.loader.SnailRetrySpiLoader;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.common.core.expression.ExpressionEngine;
import com.aizuda.snailjob.common.core.model.IdempotentIdContext;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.model.dto.RetryTaskDTO;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractReport
implements Report {
    private static final Logger log = LoggerFactory.getLogger(AbstractReport.class);
    @Autowired
    protected SnailJobProperties snailJobProperties;

    @Override
    public boolean report(String scene, String targetClassName, Object[] params) {
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, targetClassName);
        Assert.notNull((Object)retryerInfo, () -> new SnailRetryClientException("retryerInfo is null"));
        if (RetrySiteSnapshot.getStage().equals(RetrySiteSnapshot.EnumStage.REMOTE.getStage()) && !retryerInfo.isForceReport()) {
            SnailJobLog.LOCAL.info("Successfully reported, no need to repeat reporting. scene:[{}] targetClassName:[{}] args:[{}]", new Object[]{retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params});
            return Boolean.TRUE;
        }
        return this.doReport(retryerInfo, params);
    }

    public abstract boolean doReport(RetryerInfo var1, Object[] var2);

    protected RetryTaskDTO buildRetryTaskDTO(String scene, String targetClassName, Object[] args) {
        String idempotentId;
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, targetClassName);
        Method executorMethod = retryerInfo.getMethod();
        RetryTaskDTO retryTaskDTO = new RetryTaskDTO();
        try {
            Class<? extends IdempotentIdGenerate> idempotentIdGenerate = retryerInfo.getIdempotentIdGenerate();
            IdempotentIdGenerate generate = idempotentIdGenerate.newInstance();
            Method method = idempotentIdGenerate.getMethod("idGenerate", IdempotentIdContext.class);
            IdempotentIdContext idempotentIdContext = new IdempotentIdContext(scene, targetClassName, args, executorMethod.getName());
            idempotentId = (String)ReflectionUtils.invokeMethod((Method)method, (Object)generate, (Object[])new Object[]{idempotentIdContext});
        }
        catch (Exception exception) {
            SnailJobLog.LOCAL.error("Idempotent ID generation exception: {}, {}", new Object[]{scene, args, exception});
            throw new SnailRetryClientException("idempotentId generation exception: {}, {}", scene, args);
        }
        RetryArgSerializer retryArgSerializer = SnailRetrySpiLoader.loadRetryArgSerializer();
        String serialize = retryArgSerializer.serialize(args);
        retryTaskDTO.setIdempotentId(idempotentId);
        retryTaskDTO.setExecutorName(targetClassName);
        retryTaskDTO.setArgsStr(serialize);
        retryTaskDTO.setGroupName(this.snailJobProperties.getGroup());
        retryTaskDTO.setSceneName(scene);
        String expression = retryerInfo.getBizNo();
        ExpressionEngine expressionEngine = SnailRetrySpiLoader.loadExpressionEngine();
        retryTaskDTO.setBizNo((String)expressionEngine.eval(expression, new Object[]{args, executorMethod}));
        return retryTaskDTO;
    }
}

