/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.register.scan;

import com.aizuda.snailjob.client.core.IdempotentIdGenerate;
import com.aizuda.snailjob.client.core.Scanner;
import com.aizuda.snailjob.client.core.annotation.Retryable;
import com.aizuda.snailjob.client.core.callback.complete.RetryCompleteCallback;
import com.aizuda.snailjob.client.core.retryer.RetryType;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.client.core.strategy.ExecutorMethod;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
public class RetryableScanner
implements Scanner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RetryableScanner.class);
    public ApplicationContext applicationContext;

    @Override
    public List<RetryerInfo> doScan() {
        return this.scanRetryAbleMethod();
    }

    private List<RetryerInfo> scanRetryAbleMethod() {
        String[] beanDefinitionNames;
        ArrayList<RetryerInfo> retryerInfoList = new ArrayList<RetryerInfo>();
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = this.applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (Retryable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Retryable.class));
            }
            catch (Throwable ex) {
                SnailJobLog.LOCAL.error("Error loading retry information for {}: {}", new Object[]{beanDefinitionName, ex});
            }
            if (annotatedMethods == null || annotatedMethods.isEmpty()) continue;
            for (Map.Entry methodEntry : annotatedMethods.entrySet()) {
                Method executeMethod = (Method)methodEntry.getKey();
                Retryable retryable = (Retryable)methodEntry.getValue();
                RetryerInfo retryableRegistrarContext = this.resolvingRetryable(retryable, bean, executeMethod);
                retryerInfoList.add(retryableRegistrarContext);
            }
        }
        return retryerInfoList;
    }

    private RetryerInfo resolvingRetryable(Retryable retryable, Object executor, Method executorMethodName) {
        Class<? extends Throwable>[] include = retryable.include();
        Class<? extends Throwable>[] exclude = retryable.exclude();
        Class executorNotProxy = AopProxyUtils.ultimateTargetClass((Object)executor);
        String executorClassName = executorNotProxy.getName();
        Class<? extends IdempotentIdGenerate> idempotentIdGenerate = retryable.idempotentId();
        String bizNo = retryable.bizNo();
        RetryType retryType = retryable.retryStrategy();
        int localTimes = retryable.localTimes();
        int localInterval = retryable.localInterval();
        Class<? extends ExecutorMethod> retryMethod = retryable.retryMethod();
        boolean throwException = retryable.isThrowException();
        Class<? extends RetryCompleteCallback> retryCompleteCallback = retryable.retryCompleteCallback();
        boolean async = retryable.async();
        long timeout = retryable.timeout();
        TimeUnit unit = retryable.unit();
        return new RetryerInfo(retryable.scene(), executorClassName, new HashSet<Class<? extends Throwable>>(Arrays.asList(include)), new HashSet<Class<? extends Throwable>>(Arrays.asList(exclude)), executor, executorMethodName, retryType, localTimes, localInterval, idempotentIdGenerate, bizNo, retryMethod, throwException, retryCompleteCallback, async, Boolean.FALSE, timeout, unit);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

