/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.executor;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.core.callback.complete.RetryCompleteCallback;
import com.aizuda.snailjob.client.core.context.CallbackContext;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.log.RetryLogMeta;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class RemoteCallbackExecutor {
    public void doRetryCallback(CallbackContext context) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        try {
            RemoteCallbackExecutor.initLogContext(context);
            this.doCallbackForSpringBean(context);
            SnailJobLog.REMOTE.info("Task executed successfully taskId:[{}]", new Object[]{context.getRetryTaskId()});
        }
        catch (NoSuchBeanDefinitionException e) {
            this.doCallbackForOrdinaryClass(context);
        }
        finally {
            SnailJobLogManager.removeAll();
        }
    }

    private static void initLogContext(CallbackContext context) {
        RetryLogMeta retryLogMeta = new RetryLogMeta();
        retryLogMeta.setGroupName(context.getGroupName());
        retryLogMeta.setNamespaceId(context.getNamespaceId());
        retryLogMeta.setRetryTaskId(context.getRetryTaskId());
        retryLogMeta.setRetryId(context.getRetryId());
        SnailJobLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
    }

    private void doCallbackForSpringBean(CallbackContext context) {
        RetryerInfo retryerInfo = context.getRetryerInfo();
        Object[] deSerialize = context.getDeSerialize();
        Class<? extends RetryCompleteCallback> retryCompleteCallbackClazz = retryerInfo.getRetryCompleteCallback();
        RetryCompleteCallback retryCompleteCallback = (RetryCompleteCallback)SnailSpringContext.getBeanByType(retryCompleteCallbackClazz);
        switch (Objects.requireNonNull(RetryStatusEnum.getByStatus((Integer)context.getRetryStatus()))) {
            case FINISH: {
                retryCompleteCallback.doSuccessCallback(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), deSerialize);
                break;
            }
            case MAX_COUNT: {
                retryCompleteCallback.doMaxRetryCallback(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), deSerialize);
                break;
            }
            default: {
                throw new SnailRetryClientException("Callback status exception");
            }
        }
    }

    private void doCallbackForOrdinaryClass(CallbackContext context) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Method method;
        RetryerInfo retryerInfo = context.getRetryerInfo();
        Object[] deSerialize = context.getDeSerialize();
        Class<? extends RetryCompleteCallback> retryCompleteCallbackClazz = retryerInfo.getRetryCompleteCallback();
        RetryCompleteCallback retryCompleteCallback = retryCompleteCallbackClazz.newInstance();
        switch (Objects.requireNonNull(RetryStatusEnum.getByStatus((Integer)context.getRetryStatus()))) {
            case FINISH: {
                method = retryCompleteCallbackClazz.getMethod("doSuccessCallback", String.class, String.class, Object[].class);
                break;
            }
            case MAX_COUNT: {
                method = retryCompleteCallbackClazz.getMethod("doMaxRetryCallback", String.class, String.class, Object[].class);
                break;
            }
            default: {
                throw new SnailRetryClientException("Callback status exception");
            }
        }
        Assert.notNull((Object)method, () -> new SnailRetryClientException("no such method"));
        ReflectionUtils.invokeMethod((Method)method, (Object)retryCompleteCallback, (Object[])new Object[]{retryerInfo.getScene(), retryerInfo.getExecutorClassName(), deSerialize});
        SnailJobLog.REMOTE.info("Task executed successfully taskId:[{}] [{}]", new Object[]{context.getRetryTaskId()});
    }
}

