/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.executor;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.client.core.RetryExecutorParameter;
import com.aizuda.snailjob.client.core.cache.RetryerInfoCache;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.executor.AbstractRetryExecutor;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategy;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaRetryExecutor
extends AbstractRetryExecutor<WaitStrategy, StopStrategy> {
    private static final Logger log = LoggerFactory.getLogger(GuavaRetryExecutor.class);

    public GuavaRetryExecutor(String sceneName, String executorClassName) {
        this.retryerInfo = RetryerInfoCache.get(sceneName, executorClassName);
        Assert.notNull((Object)this.retryerInfo, () -> new SnailRetryClientException("retryerInfo is null sceneName:[{}] executorClassName:[{}]", sceneName, executorClassName));
    }

    public GuavaRetryExecutor() {
    }

    @Override
    public Retryer build(RetryExecutorParameter<WaitStrategy, StopStrategy> parameter) {
        RetryerBuilder retryerBuilder = RetryerBuilder.newBuilder();
        retryerBuilder.retryIfException(throwable -> true);
        retryerBuilder.withWaitStrategy(parameter.backOff());
        retryerBuilder.withStopStrategy(parameter.stop());
        for (RetryListener retryListener : parameter.getRetryListeners()) {
            retryerBuilder.withRetryListener(retryListener);
        }
        return retryerBuilder.build();
    }

    @Override
    public <V> V call(Retryer<V> retryer, Callable<V> callable, Consumer<Throwable> retryError, Consumer<V> retrySuccess) throws Exception {
        Object result = null;
        try {
            result = retryer.call(callable);
            retrySuccess.accept(result);
        }
        catch (RetryException e) {
            SnailJobLog.LOCAL.debug("Business system retry exception:", new Object[]{e.getLastFailedAttempt().getExceptionCause()});
            retryError.accept(e.getLastFailedAttempt().getExceptionCause());
        }
        return (V)result;
    }
}

