/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.plugin;

import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderPlugins {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderPlugins.class);

    private RequestHeaderPlugins() {
    }

    public static Map<String, String> requestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        SnailJobHeaders retryHeader = RetrySiteSnapshot.getRetryHeader();
        if (Objects.nonNull(retryHeader)) {
            long callRemoteTime = System.currentTimeMillis();
            Long entryMethodTime = RetrySiteSnapshot.getEntryMethodTime();
            if (Objects.isNull(entryMethodTime)) {
                SnailJobLog.LOCAL.warn("entry method time is null. retryId:[{}]", new Object[]{retryHeader.getRetryId()});
            } else {
                long transmitTime = retryHeader.getDdl() - (callRemoteTime - entryMethodTime);
                SnailJobLog.LOCAL.info("RPC\u4f20\u9012header\u5934 callRemoteTime:[{}] - entryMethodTime:[{}] = transmitTime:[{}]", new Object[]{callRemoteTime, entryMethodTime, transmitTime});
                if (transmitTime > 0L) {
                    retryHeader.setDdl(transmitTime);
                    RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
                } else {
                    throw new SnailRetryClientException("\u8c03\u7528\u94fe\u8d85\u65f6, \u4e0d\u5728\u7ee7\u7eed\u8c03\u7528\u540e\u9762\u8bf7\u6c42");
                }
            }
            header.put("snail-job", JsonUtil.toJsonString((Object)retryHeader));
        }
        return header;
    }
}

