/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.executor;

import com.aizuda.snailjob.client.core.RetryExecutor;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.client.core.strategy.ExecutorAnnotationMethod;
import com.aizuda.snailjob.client.core.strategy.ExecutorMethod;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryExecutor<BR, SR>
implements RetryExecutor<BR, SR> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryExecutor.class);
    protected RetryerInfo retryerInfo;

    @Override
    public Object execute(Object ... params) {
        return this.doExecute(params);
    }

    public Object doExecute(Object ... params) {
        Class<? extends ExecutorMethod> retryMethodClass = this.retryerInfo.getExecutorMethod();
        if (retryMethodClass.isAssignableFrom(ExecutorAnnotationMethod.class)) {
            SnailJobLog.LOCAL.debug("\u6267\u884c\u6ce8\u89e3\u91cd\u8bd5\u65b9\u6cd5\uff1a{},\u53c2\u6570\u4e3a\uff1a{}", new Object[]{retryMethodClass.getName(), JsonUtil.toJsonString((Object)params)});
            ExecutorAnnotationMethod retryAnnotationMethod = new ExecutorAnnotationMethod(this.retryerInfo);
            return retryAnnotationMethod.doExecute(params);
        }
        SnailJobLog.LOCAL.debug("\u6267\u884c\u81ea\u5b9a\u4e49\u91cd\u8bd5\u65b9\u6cd5\uff1a{},\u53c2\u6570\u4e3a\uff1a{}", new Object[]{retryMethodClass.getName(), JsonUtil.toJsonString((Object)params)});
        ExecutorMethod executorMethod = (ExecutorMethod)SnailSpringContext.getBeanByType(retryMethodClass);
        return executorMethod.doExecute(params);
    }

    @Override
    public RetryerInfo getRetryerInfo() {
        return this.retryerInfo;
    }
}

