/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.register.scan;

import com.aizuda.snailjob.client.core.IdempotentIdGenerate;
import com.aizuda.snailjob.client.core.Scanner;
import com.aizuda.snailjob.client.core.annotation.ExecutorMethodRegister;
import com.aizuda.snailjob.client.core.callback.RetryCompleteCallback;
import com.aizuda.snailjob.client.core.retryer.RetryType;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ExecutorMethodScanner
implements Scanner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ExecutorMethodScanner.class);
    public ApplicationContext applicationContext;

    @Override
    public List<RetryerInfo> doScan() {
        String[] beanDefinitionNames;
        ArrayList<RetryerInfo> retryerInfoList = new ArrayList<RetryerInfo>();
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = this.applicationContext.getBean(beanDefinitionName);
            ExecutorMethodRegister annotation = bean.getClass().getAnnotation(ExecutorMethodRegister.class);
            if (!Objects.nonNull(annotation)) continue;
            RetryerInfo retryerInfo = this.resolvingRetryable(annotation, bean);
            Optional.ofNullable(retryerInfo).ifPresent(retryerInfoList::add);
        }
        return retryerInfoList;
    }

    private RetryerInfo resolvingRetryable(ExecutorMethodRegister retryable, Object executor) {
        try {
            Class executorNotProxy = AopUtils.getTargetClass((Object)executor);
            String executorClassName = executorNotProxy.getName();
            Class<? extends IdempotentIdGenerate> idempotentIdGenerate = retryable.idempotentId();
            Method executorMethodName = executorNotProxy.getMethod("doExecute", Object.class);
            Class<? extends RetryCompleteCallback> retryCompleteCallback = retryable.retryCompleteCallback();
            boolean async = retryable.async();
            long timeout = retryable.timeout();
            TimeUnit unit = retryable.unit();
            boolean forceReport = retryable.forceReport();
            return new RetryerInfo(retryable.scene(), executorClassName, new HashSet<Class<? extends Throwable>>(Collections.emptyList()), new HashSet<Class<? extends Throwable>>(Collections.emptyList()), executor, executorMethodName, RetryType.ONLY_REMOTE, 1, 1, idempotentIdGenerate, "", executor.getClass(), Boolean.TRUE, retryCompleteCallback, async, forceReport, timeout, unit);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("{}\u91cd\u8bd5\u4fe1\u606f\u52a0\u8f7d\u62a5\u9519\uff1a{}", new Object[]{executor.getClass().getName(), e});
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

