package com.aitime.android.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Tools for MD5 Digest Algorithm
 */
public final class MD5 {

    private MD5() {
        throw new UnsupportedOperationException("Instantiation operation is not supported.");
    }

    static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException var1) {
            throw new RuntimeException(var1);
        }
    }

    public static byte[] md5(byte[] data) {
        return getDigest().digest(data);
    }

    public static byte[] md5(String data) {
        return md5(data.getBytes());
    }

    public static String md5Hex(byte[] data) {
        return toHexString(md5(data));
    }

    public static String md5Hex(String data) {
        return toHexString(md5(data));
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex.toUpperCase());
        }
        return builder.toString();
    }

    public static byte[] toByteArray(String data) {
        byte[] buf = new byte[data.length() / 2];
        int j = 0;
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte) (Character.digit(data.charAt(j++), 16) << 4 | Character.digit(data.charAt(j++), 16));
        }
        return buf;
    }

    public static String appendParam(String returnStr, String paramId, String paramValue) {
        if (!"".equals(returnStr)) {
            if (!"".equals(paramValue)) {
                returnStr = returnStr + "&" + paramId + "=" + paramValue;
            }
        } else if (!"".equals(paramValue)) {
            returnStr = paramId + "=" + paramValue;
        }
        return returnStr;
    }

    public static String appendParam_all(String returnStr, String paramId, String paramValue) {
        if (!"".equals(returnStr)) {
            returnStr = returnStr + "&" + paramId + "=" + paramValue;
        } else {
            returnStr = paramId + "=" + paramValue;
        }

        return returnStr;
    }

}
