package com.aitime.android.security;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * Tools for Android encryption and decryption
 */
public final class Security {

    private static final String KEY = "9188123123123345";
    private static final String VECTOR = "9188123123123345";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    private Security() {
        throw new UnsupportedOperationException("Instantiation operation is not supported.");
    }

    /**
     * Encryption
     *
     * @param content content to be encrypted
     * @see #encrypt(String, String, String)
     */
    public static String encrypt(String content) {
        return encrypt(KEY, VECTOR, content);
    }

    /**
     * Encryption
     *
     * @param secretKey Key for encryption, consisting of 16-bit characters
     * @param vector    vector offset
     * @param content   content to be encrypted
     */
    public static String encrypt(String secretKey, String vector, String content) {
        if (content == null || content.isEmpty()) {
            return "";
        }
        try {
            byte[] bytes = AES.encrypt(secretKey, vector, content.getBytes(UTF_8));
            return Base64.encodeToString(bytes, Base64.DEFAULT).trim();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * Decryption
     *
     * @param content content to be decrypted
     * @see #dencrypt(String, String, String)
     */
    public static String dencrypt(String content) {
        return dencrypt(KEY, VECTOR, content);
    }

    /**
     * Decryption
     *
     * @param secretKey Key for decryption, consisting of 16-bit characters
     * @param vector    vector
     * @param content   content to be decrypted
     */
    public static String dencrypt(String secretKey, String vector, String content) {
        if (content == null || content.isEmpty()) {
            return "";
        }
        try {
            byte[] bytes = AES.decrypt(secretKey, vector, Base64.decode(content, Base64.DEFAULT));
            return (new String(bytes, UTF_8)).trim();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

}
