/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ArrayHash<KEY, VALUE>
extends HashMap<KEY, VALUE> {
    private static final long serialVersionUID = 1L;
    private List<KEY> orderedKeys;

    public ArrayHash() {
        this.orderedKeys = new ArrayList<KEY>();
    }

    public ArrayHash(int capacity, float loadFactor) {
        super(capacity, loadFactor);
        this.orderedKeys = new ArrayList<KEY>(capacity);
    }

    public ArrayHash(int capacity) {
        super(capacity);
        this.orderedKeys = new ArrayList<KEY>(capacity);
    }

    public ArrayHash(ArrayHash<KEY, VALUE> original) {
        super(original);
        this.orderedKeys = original == null ? new ArrayList<KEY>() : new ArrayList<KEY>(original.orderedKeys);
    }

    @Override
    public VALUE put(KEY key, VALUE value) throws NullPointerException {
        this.put(false, key, value);
        return value;
    }

    public VALUE putHead(KEY key, VALUE value) throws NullPointerException {
        this.put(true, key, value);
        return value;
    }

    private void put(boolean head, KEY key, VALUE value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.containsKey(key)) {
            this.orderedKeys.remove(key);
            this.remove(key);
        }
        super.put(key, value);
        if (head) {
            this.orderedKeys.add(0, key);
        } else {
            int size = this.orderedKeys.size();
            this.orderedKeys.add(size, key);
        }
    }

    public void putAtIndex(int idx, KEY key, VALUE value) throws IndexOutOfBoundsException {
        if (idx < 0 || idx > this.size()) {
            throw new IndexOutOfBoundsException("Index " + idx + " is beyond the bounds of this array. Size: " + this.size());
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.containsKey(key)) {
            this.orderedKeys.remove(key);
            this.remove(key);
        }
        super.put(key, value);
        this.orderedKeys.add(idx, key);
    }

    public VALUE getAtIndex(int index) {
        if (index >= 0 && index < this.orderedKeys.size()) {
            return (VALUE)this.get(this.orderedKeys.get(index));
        }
        return null;
    }

    @Override
    public VALUE remove(Object key) {
        if (this.containsKey(key)) {
            Object value = super.remove(key);
            this.orderedKeys.remove(key);
            return (VALUE)value;
        }
        return null;
    }

    public boolean removeValue(VALUE value) {
        if (!this.containsValue(value)) {
            return false;
        }
        Object removeKey = null;
        for (Object key : this.keySet()) {
            if (this.get(key) != value) continue;
            removeKey = key;
            break;
        }
        super.remove(removeKey);
        this.orderedKeys.remove(removeKey);
        return true;
    }

    public VALUE removeHead() {
        if (this.orderedKeys.size() > 0) {
            return (VALUE)super.remove(this.orderedKeys.remove(0));
        }
        return null;
    }

    public VALUE removeAtIndex(int position) {
        if (position >= 0 && position < this.orderedKeys.size()) {
            return (VALUE)super.remove(this.orderedKeys.remove(position));
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.orderedKeys.clear();
    }

    @Override
    public int size() {
        if (this.orderedKeys.size() != super.size()) {
            throw new IllegalStateException("List and HashMap are out of sync");
        }
        return this.orderedKeys.size();
    }

    public int indexOf(KEY key) {
        return this.orderedKeys.indexOf(key);
    }

    public KEY keyAtIndex(int index) {
        return this.orderedKeys.get(index);
    }

    public List<KEY> getOrderedKeys() {
        return new ArrayList<KEY>(this.orderedKeys);
    }
}

