/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.widget.Toast;

public final class Toaster {
    private static final Handler uiHandler = new Handler(Looper.getMainLooper());
    private final Context context;

    public Toaster with(@NonNull Context context) {
        return new Toaster(context);
    }

    public static void light(@NonNull Context context, @StringRes int txtRes, Object ... args) {
        Toaster.toast(context, context.getString(txtRes, args), 0);
    }

    public static void light(@NonNull Context context, @StringRes int txtRes) {
        Toaster.toast(context, context.getString(txtRes), 0);
    }

    public static void light(@NonNull Context context, CharSequence txt) {
        Toaster.toast(context, txt, 0);
    }

    public static void dark(@NonNull Context context, @StringRes int txtRes, Object ... args) {
        Toaster.toast(context, context.getString(txtRes, args), 1);
    }

    public static void dark(@NonNull Context context, @StringRes int txtRes) {
        Toaster.toast(context, context.getString(txtRes), 1);
    }

    public static void dark(@NonNull Context context, CharSequence txt) {
        Toaster.toast(context, txt, 1);
    }

    public void light(@StringRes int txtRes, Object ... args) {
        Toaster.light(this.context, txtRes, args);
    }

    public void light(@StringRes int txtRes) {
        Toaster.light(this.context, txtRes);
    }

    public void light(CharSequence txt) {
        Toaster.light(this.context, txt);
    }

    public void dark(@StringRes int txtRes, Object ... args) {
        Toaster.dark(this.context, txtRes, args);
    }

    public void dark(@StringRes int txtRes) {
        Toaster.dark(this.context, txtRes);
    }

    public void dark(CharSequence txt) {
        Toaster.dark(this.context, txt);
    }

    private static void toast(final @NonNull Context context, final @NonNull CharSequence text, final int duration) {
        if (Toaster.isMainThread()) {
            Toast.makeText((Context)context, (CharSequence)text, (int)duration).show();
        } else {
            uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)context, (CharSequence)text, (int)duration).show();
                }
            });
        }
    }

    @TargetApi(value=23)
    private static boolean isMainThread() {
        return 23 >= Build.VERSION.SDK_INT ? Looper.getMainLooper().isCurrentThread() : Looper.myLooper() == Looper.getMainLooper();
    }

    private Toaster(@NonNull Context c) {
        this.context = c;
    }
}

