/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.future;

import android.support.annotation.Nullable;
import com.airg.android.async.future.Promise;
import com.airg.android.logging.Logger;
import com.airg.android.logging.TaggedLogger;
import java.util.concurrent.Executor;

public final class SimplePromise<RESULT>
implements Promise<RESULT> {
    private final Object $lock = new Object[0];
    private static final TaggedLogger LOG = Logger.tag((String)"ASYNC:SP");
    private Promise.OnCompleteListener<RESULT> onCompleteListener;
    private Promise.OnFailListener onFailListener;
    private Promise.OnCancelListener onCancelListener;
    private volatile Throwable error = null;
    private volatile RESULT result = null;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private final Executor callbackExecutor;

    public SimplePromise() {
        this(null);
    }

    public SimplePromise(@Nullable Executor executor) {
        this.callbackExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void success(RESULT r) {
        Object object = this.$lock;
        synchronized (object) {
            this.assertNotComplete();
            if (this.cancelled) {
                LOG.d("Promise has been cancelled. Ignoring result.");
                return;
            }
            LOG.d("Promise kept: %s", new Object[]{r});
            this.done = true;
            this.result = r;
            this.notifyDoneMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            this.assertNotComplete();
            if (this.cancelled) {
                LOG.d("Promise has been cancelled. Ignoring failure.");
                return;
            }
            LOG.d(t, "Promise broken");
            this.error = t;
            this.done = true;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.done || this.isFailed()) {
                LOG.d("Ignoring cancel request (already %s)", new Object[]{this.done ? "done" : "failed"});
                return;
            }
            LOG.d("Promise cancelled.");
            this.cancelled = true;
            this.done = true;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimplePromise<RESULT> onComplete(Promise.OnCompleteListener<RESULT> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCompleteListener = listener;
            this.notifyDoneMaybe();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimplePromise<RESULT> onFail(Promise.OnFailListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onFailListener = listener;
            this.notifyFailedMaybe();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimplePromise<RESULT> onCancel(Promise.OnCancelListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCancelListener = listener;
            this.notifyCancelledMaybe();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean succeeded() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done && null != this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done && null != this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.$lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    private void assertNotComplete() {
        if (this.isDone()) {
            throw new IllegalStateException("Already marked as " + (null == this.error ? "done" : "failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDoneMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.done || null == this.onCompleteListener || this.cancelled) {
                return;
            }
            LOG.d("Notifying promise completion");
            SimplePromise.runOnExecutor(new Runnable(){

                @Override
                public void run() {
                    SimplePromise.this.onCompleteListener.onComplete(SimplePromise.this.result);
                }
            }, this.callbackExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailedMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isFailed() || null == this.onFailListener || this.cancelled) {
                return;
            }
            LOG.d("Notifying promise failure");
            SimplePromise.runOnExecutor(new Runnable(){

                @Override
                public void run() {
                    SimplePromise.this.onFailListener.onFailed(SimplePromise.this.error);
                }
            }, this.callbackExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelledMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.cancelled || null == this.onCancelListener) {
                return;
            }
            LOG.d("Notifying promise cancellation");
            SimplePromise.runOnExecutor(new Runnable(){

                @Override
                public void run() {
                    SimplePromise.this.onCancelListener.onCancelled();
                }
            }, this.callbackExecutor);
        }
    }

    private static void runOnExecutor(Runnable task, Executor executor) {
        if (null == executor) {
            task.run();
        } else {
            executor.execute(task);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePromise)) {
            return false;
        }
        SimplePromise other = (SimplePromise)o;
        Promise.OnCompleteListener<RESULT> this$onCompleteListener = this.onCompleteListener;
        Promise.OnCompleteListener<RESULT> other$onCompleteListener = other.onCompleteListener;
        if (this$onCompleteListener == null ? other$onCompleteListener != null : !this$onCompleteListener.equals(other$onCompleteListener)) {
            return false;
        }
        Promise.OnFailListener this$onFailListener = this.onFailListener;
        Promise.OnFailListener other$onFailListener = other.onFailListener;
        if (this$onFailListener == null ? other$onFailListener != null : !this$onFailListener.equals(other$onFailListener)) {
            return false;
        }
        Promise.OnCancelListener this$onCancelListener = this.onCancelListener;
        Promise.OnCancelListener other$onCancelListener = other.onCancelListener;
        if (this$onCancelListener == null ? other$onCancelListener != null : !this$onCancelListener.equals(other$onCancelListener)) {
            return false;
        }
        Throwable this$error = this.error;
        Throwable other$error = other.error;
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        RESULT this$result = this.result;
        RESULT other$result = other.result;
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        if (this.isDone() != other.isDone()) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        Executor this$callbackExecutor = this.callbackExecutor;
        Executor other$callbackExecutor = other.callbackExecutor;
        return !(this$callbackExecutor == null ? other$callbackExecutor != null : !this$callbackExecutor.equals(other$callbackExecutor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Promise.OnCompleteListener<RESULT> $onCompleteListener = this.onCompleteListener;
        result = result * 59 + ($onCompleteListener == null ? 43 : $onCompleteListener.hashCode());
        Promise.OnFailListener $onFailListener = this.onFailListener;
        result = result * 59 + ($onFailListener == null ? 43 : $onFailListener.hashCode());
        Promise.OnCancelListener $onCancelListener = this.onCancelListener;
        result = result * 59 + ($onCancelListener == null ? 43 : $onCancelListener.hashCode());
        Throwable $error = this.error;
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        RESULT $result = this.result;
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        result = result * 59 + (this.isDone() ? 79 : 97);
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        Executor $callbackExecutor = this.callbackExecutor;
        result = result * 59 + ($callbackExecutor == null ? 43 : $callbackExecutor.hashCode());
        return result;
    }
}

