/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.future;

import com.airg.android.async.future.Promise;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class FuturePromise<RESULT>
extends FutureTask<RESULT>
implements Promise<RESULT> {
    private final Object $lock = new Object[0];
    private Promise.OnCompleteListener<RESULT> onCompleteListener;
    private Promise.OnFailListener onFailListener;
    private Promise.OnCancelListener onCancelListener;
    private RESULT result;
    private Throwable error = null;

    public FuturePromise(Callable<RESULT> callable) {
        super(callable);
    }

    public FuturePromise(Runnable runnable, RESULT result) {
        super(runnable, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCallback(Object callback) {
        Object object = this.$lock;
        synchronized (object) {
            int count = 0;
            if (callback instanceof Promise.OnCompleteListener) {
                this.onComplete((Promise.OnCompleteListener)callback);
                ++count;
            }
            if (callback instanceof Promise.OnFailListener) {
                this.onFail((Promise.OnFailListener)callback);
                ++count;
            }
            if (callback instanceof Promise.OnCancelListener) {
                this.onCancel((Promise.OnCancelListener)callback);
                ++count;
            }
            if (0 == count) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'%s' does not implement '%s', '%s', or '%s'", callback.getClass().getSimpleName(), Promise.OnCompleteListener.class.getCanonicalName(), Promise.OnFailListener.class.getCanonicalName(), Promise.OnCancelListener.class.getCanonicalName()));
            }
        }
    }

    public boolean succeeded() {
        return this.isDone() && !this.isFailed() && !this.isCancelled();
    }

    public FuturePromise<RESULT> completed(Promise.OnCompleteListener<RESULT> listener) {
        this.onComplete(listener);
        return this;
    }

    public FuturePromise<RESULT> failed(Promise.OnFailListener listener) {
        this.onFail(listener);
        return this;
    }

    public FuturePromise<RESULT> cancelled(Promise.OnCancelListener listener) {
        this.onCancel(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void success(RESULT r) {
        Object object = this.$lock;
        synchronized (object) {
            this.result = r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            this.error = t;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled() {
        Object object = this.$lock;
        synchronized (object) {
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onComplete(Promise.OnCompleteListener<RESULT> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCompleteListener = listener;
            try {
                this.notifyDoneMaybe();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onFail(Promise.OnFailListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onFailListener = listener;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onCancel(Promise.OnCancelListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCancelListener = listener;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.$lock;
        synchronized (object) {
            return null != this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void set(RESULT r) {
        Object object = this.$lock;
        synchronized (object) {
            this.success(r);
            super.set(this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setException(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            this.failed(t);
            super.setException(t);
        }
    }

    @Override
    protected void done() {
        super.done();
        if (this.isCancelled()) {
            this.cancelled();
        } else {
            this.notifyDoneMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDoneMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isDone() || null == this.onCompleteListener) {
                return;
            }
            this.onCompleteListener.onComplete(this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelledMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isCancelled() || null == this.onCancelListener) {
                return;
            }
            this.onCancelListener.onCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailedMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isFailed() || null == this.onFailListener) {
                return;
            }
            this.onFailListener.onFailed(this.error);
        }
    }
}

