/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.future;

import com.airg.android.async.future.Promise;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class FuturePromise<RESULT>
extends FutureTask<RESULT>
implements Promise<RESULT> {
    private final Object $lock = new Object[0];
    private Promise.OnCompleteListener<RESULT> onCompleteListener;
    private Promise.OnFailListener onFailListener;
    private Promise.OnCancelListener onCancelListener;
    private Throwable error = null;
    private ExecutionState executionState = ExecutionState.Pending;

    public FuturePromise(Callable<RESULT> callable) {
        super(callable);
    }

    public FuturePromise(Runnable runnable, RESULT result) {
        super(runnable, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCallback(Object callback) {
        Object object = this.$lock;
        synchronized (object) {
            int count = 0;
            if (callback instanceof Promise.OnCompleteListener) {
                this.onComplete((Promise.OnCompleteListener)callback);
                ++count;
            }
            if (callback instanceof Promise.OnFailListener) {
                this.onFail((Promise.OnFailListener)callback);
                ++count;
            }
            if (callback instanceof Promise.OnCancelListener) {
                this.onCancel((Promise.OnCancelListener)callback);
                ++count;
            }
            if (0 == count) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'%s' does not implement '%s', '%s', or '%s'", callback.getClass().getSimpleName(), Promise.OnCompleteListener.class.getCanonicalName(), Promise.OnFailListener.class.getCanonicalName(), Promise.OnCancelListener.class.getCanonicalName()));
            }
        }
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(RESULT result) {
        Object object = this.$lock;
        synchronized (object) {
            this.executionState = ExecutionState.Completed;
            this.notifyDoneMaybe(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            this.executionState = ExecutionState.Failed;
            this.error = t;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled() {
        Object object = this.$lock;
        synchronized (object) {
            this.executionState = ExecutionState.Cancelled;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onComplete(Promise.OnCompleteListener<RESULT> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCompleteListener = listener;
            try {
                this.notifyDoneMaybe(this.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onFail(Promise.OnFailListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onFailListener = listener;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onCancel(Promise.OnCancelListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCancelListener = listener;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.$lock;
        synchronized (object) {
            return this.executionState == ExecutionState.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void set(RESULT result) {
        Object object = this.$lock;
        synchronized (object) {
            super.set(result);
            this.done(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setException(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            super.setException(t);
            this.failed(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.$lock;
        synchronized (object) {
            boolean superCancel = super.cancel(mayInterruptIfRunning);
            this.cancelled();
            return superCancel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.$lock;
        synchronized (object) {
            this.executionState = ExecutionState.Running;
            super.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDoneMaybe(RESULT result) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.executionState != ExecutionState.Completed || null == this.onCompleteListener) {
                return;
            }
            this.onCompleteListener.onComplete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelledMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.executionState != ExecutionState.Cancelled || null == this.onCancelListener) {
                return;
            }
            this.onCancelListener.onCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailedMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.executionState != ExecutionState.Failed || null == this.onFailListener) {
                return;
            }
            this.onFailListener.onFailed(this.error);
        }
    }

    public static enum ExecutionState {
        Pending,
        Running,
        Completed,
        Failed,
        Cancelled;

    }
}

