/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.util.SparseArray;
import androidx.recyclerview.widget.RecyclerView;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/airbnb/epoxy/UnboundedViewPool;", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "()V", "scrapHeaps", "Landroid/util/SparseArray;", "Ljava/util/Queue;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "clear", "", "getRecycledView", "viewType", "", "getRecycledViewCount", "getScrapHeapForType", "putRecycledView", "viewHolder", "setMaxRecycledViews", "max", "epoxy-adapter_release"})
public final class UnboundedViewPool
extends RecyclerView.RecycledViewPool {
    private final SparseArray<Queue<RecyclerView.ViewHolder>> scrapHeaps = new SparseArray();

    public void clear() {
        this.scrapHeaps.clear();
    }

    public void setMaxRecycledViews(int viewType, int max) {
        throw (Throwable)new UnsupportedOperationException("UnboundedViewPool does not support setting a maximum number of recycled views");
    }

    @Nullable
    public RecyclerView.ViewHolder getRecycledView(int viewType) {
        Queue scrapHeap;
        Queue queue = scrapHeap = (Queue)this.scrapHeaps.get(viewType);
        return queue != null ? (RecyclerView.ViewHolder)queue.poll() : null;
    }

    public void putRecycledView(@NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        this.getScrapHeapForType(viewHolder.getItemViewType()).add(viewHolder);
    }

    public int getRecycledViewCount(int viewType) {
        Queue queue = (Queue)this.scrapHeaps.get(viewType);
        return queue != null ? queue.size() : 0;
    }

    private final Queue<RecyclerView.ViewHolder> getScrapHeapForType(int viewType) {
        Queue scrapHeap = (Queue)this.scrapHeaps.get(viewType);
        if (scrapHeap == null) {
            scrapHeap = new LinkedList();
            this.scrapHeaps.put(viewType, (Object)scrapHeap);
        }
        return scrapHeap;
    }
}

