/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Handler;
import com.airbnb.epoxy.EpoxyController;

public abstract class Typed2EpoxyController<T, U>
extends EpoxyController {
    private T data1;
    private U data2;
    private boolean allowModelBuildRequests;

    public Typed2EpoxyController() {
    }

    public Typed2EpoxyController(Handler modelBuildingHandler, Handler diffingHandler) {
        super(modelBuildingHandler, diffingHandler);
    }

    public void setData(T data1, U data2) {
        this.data1 = data1;
        this.data2 = data2;
        this.allowModelBuildRequests = true;
        this.requestModelBuild();
        this.allowModelBuildRequests = false;
    }

    @Override
    public final void requestModelBuild() {
        if (!this.allowModelBuildRequests) {
            throw new IllegalStateException("You cannot call `requestModelBuild` directly. Call `setData` instead to trigger a model refresh with new data.");
        }
        super.requestModelBuild();
    }

    @Override
    public void moveModel(int fromPosition, int toPosition) {
        this.allowModelBuildRequests = true;
        super.moveModel(fromPosition, toPosition);
        this.allowModelBuildRequests = false;
    }

    @Override
    public void requestDelayedModelBuild(int delayMs) {
        if (!this.allowModelBuildRequests) {
            throw new IllegalStateException("You cannot call `requestModelBuild` directly. Call `setData` instead to trigger a model refresh with new data.");
        }
        super.requestDelayedModelBuild(delayMs);
    }

    @Override
    protected final void buildModels() {
        if (!this.isBuildingModels()) {
            throw new IllegalStateException("You cannot call `buildModels` directly. Call `setData` instead to trigger a model refresh with new data.");
        }
        this.buildModels(this.data1, this.data2);
    }

    protected abstract void buildModels(T var1, U var2);
}

