/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import androidx.annotation.NonNull;
import com.airbnb.epoxy.EpoxyModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class ModelList
extends ArrayList<EpoxyModel<?>> {
    private boolean notificationsPaused;
    private ModelListObserver observer;

    ModelList(int expectedModelCount) {
        super(expectedModelCount);
    }

    ModelList() {
    }

    void pauseNotifications() {
        if (this.notificationsPaused) {
            throw new IllegalStateException("Notifications already paused");
        }
        this.notificationsPaused = true;
    }

    void resumeNotifications() {
        if (!this.notificationsPaused) {
            throw new IllegalStateException("Notifications already resumed");
        }
        this.notificationsPaused = false;
    }

    void setObserver(ModelListObserver observer) {
        this.observer = observer;
    }

    private void notifyInsertion(int positionStart, int itemCount) {
        if (!this.notificationsPaused && this.observer != null) {
            this.observer.onItemRangeInserted(positionStart, itemCount);
        }
    }

    private void notifyRemoval(int positionStart, int itemCount) {
        if (!this.notificationsPaused && this.observer != null) {
            this.observer.onItemRangeRemoved(positionStart, itemCount);
        }
    }

    @Override
    public EpoxyModel<?> set(int index, EpoxyModel<?> element) {
        EpoxyModel<?> previousModel = super.set(index, element);
        if (previousModel.id() != element.id()) {
            this.notifyRemoval(index, 1);
            this.notifyInsertion(index, 1);
        }
        return previousModel;
    }

    @Override
    public boolean add(EpoxyModel<?> epoxyModel) {
        this.notifyInsertion(this.size(), 1);
        return super.add(epoxyModel);
    }

    @Override
    public void add(int index, EpoxyModel<?> element) {
        this.notifyInsertion(index, 1);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends EpoxyModel<?>> c) {
        this.notifyInsertion(this.size(), c.size());
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends EpoxyModel<?>> c) {
        this.notifyInsertion(index, c.size());
        return super.addAll(index, c);
    }

    @Override
    public EpoxyModel<?> remove(int index) {
        this.notifyRemoval(index, 1);
        return (EpoxyModel)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.notifyRemoval(index, 1);
        super.remove(index);
        return true;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.notifyRemoval(0, this.size());
            super.clear();
        }
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        this.notifyRemoval(fromIndex, toIndex - fromIndex);
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = false;
        Iterator<EpoxyModel<?>> it = this.iterator();
        while (it.hasNext()) {
            if (!collection.contains(it.next())) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean result = false;
        Iterator<EpoxyModel<?>> it = this.iterator();
        while (it.hasNext()) {
            if (collection.contains(it.next())) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    @Override
    @NonNull
    public Iterator<EpoxyModel<?>> iterator() {
        return new Itr();
    }

    @Override
    @NonNull
    public ListIterator<EpoxyModel<?>> listIterator() {
        return new ListItr(0);
    }

    @Override
    @NonNull
    public ListIterator<EpoxyModel<?>> listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    @NonNull
    public List<EpoxyModel<?>> subList(int start, int end) {
        if (start >= 0 && end <= this.size()) {
            if (start <= end) {
                return new SubList(this, start, end);
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    static /* synthetic */ int access$100(ModelList x0) {
        return x0.modCount;
    }

    private static class SubList
    extends AbstractList<EpoxyModel<?>> {
        private final ModelList fullList;
        private int offset;
        private int size;

        SubList(ModelList list, int start, int end) {
            this.fullList = list;
            this.modCount = this.fullList.modCount;
            this.offset = start;
            this.size = end - start;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void add(int location, EpoxyModel<?> object) {
            if (this.modCount != this.fullList.modCount) throw new ConcurrentModificationException();
            if (location < 0 || location > this.size) throw new IndexOutOfBoundsException();
            this.fullList.add(location + this.offset, object);
            ++this.size;
            this.modCount = this.fullList.modCount;
        }

        @Override
        public boolean addAll(int location, Collection<? extends EpoxyModel<?>> collection) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    boolean result = this.fullList.addAll(location + this.offset, (Collection<? extends EpoxyModel<?>>)collection);
                    if (result) {
                        this.size += collection.size();
                        this.modCount = this.fullList.modCount;
                    }
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends EpoxyModel<?>> collection) {
            if (this.modCount == this.fullList.modCount) {
                boolean result = this.fullList.addAll(this.offset + this.size, (Collection<? extends EpoxyModel<?>>)collection);
                if (result) {
                    this.size += collection.size();
                    this.modCount = this.fullList.modCount;
                }
                return result;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public EpoxyModel<?> get(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location < this.size) {
                    return (EpoxyModel)this.fullList.get(location + this.offset);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        @NonNull
        public Iterator<EpoxyModel<?>> iterator() {
            return this.listIterator(0);
        }

        @Override
        @NonNull
        public ListIterator<EpoxyModel<?>> listIterator(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    return new SubListIterator(this.fullList.listIterator(location + this.offset), this, this.offset, this.size);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public EpoxyModel<?> remove(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location < this.size) {
                    Object result = this.fullList.remove(location + this.offset);
                    --this.size;
                    this.modCount = this.fullList.modCount;
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        protected void removeRange(int start, int end) {
            if (start != end) {
                if (this.modCount == this.fullList.modCount) {
                    this.fullList.removeRange(start + this.offset, end + this.offset);
                    this.size -= end - start;
                    this.modCount = this.fullList.modCount;
                } else {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public EpoxyModel<?> set(int location, EpoxyModel<?> object) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location < this.size) {
                    return this.fullList.set(location + this.offset, object);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int size() {
            if (this.modCount == this.fullList.modCount) {
                return this.size;
            }
            throw new ConcurrentModificationException();
        }

        void sizeChanged(boolean increment) {
            this.size = increment ? ++this.size : --this.size;
            this.modCount = this.fullList.modCount;
        }

        private static final class SubListIterator
        implements ListIterator<EpoxyModel<?>> {
            private final SubList subList;
            private final ListIterator<EpoxyModel<?>> iterator;
            private int start;
            private int end;

            SubListIterator(ListIterator<EpoxyModel<?>> it, SubList list, int offset, int length) {
                this.iterator = it;
                this.subList = list;
                this.start = offset;
                this.end = this.start + length;
            }

            @Override
            public void add(EpoxyModel<?> object) {
                this.iterator.add(object);
                this.subList.sizeChanged(true);
                ++this.end;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.nextIndex() < this.end;
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator.previousIndex() >= this.start;
            }

            @Override
            public EpoxyModel<?> next() {
                if (this.iterator.nextIndex() < this.end) {
                    return this.iterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.iterator.nextIndex() - this.start;
            }

            @Override
            public EpoxyModel<?> previous() {
                if (this.iterator.previousIndex() >= this.start) {
                    return this.iterator.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int previousIndex() {
                int previous = this.iterator.previousIndex();
                if (previous >= this.start) {
                    return previous - this.start;
                }
                return -1;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                this.subList.sizeChanged(false);
                --this.end;
            }

            @Override
            public void set(EpoxyModel<?> object) {
                this.iterator.set(object);
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<EpoxyModel<?>> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public EpoxyModel<?> previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            this.cursor = i;
            this.lastRet = i;
            return (EpoxyModel)ModelList.this.get(i);
        }

        @Override
        public void set(EpoxyModel<?> e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ModelList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(EpoxyModel<?> e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ModelList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ModelList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<EpoxyModel<?>> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = ModelList.access$100(ModelList.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ModelList.this.size();
        }

        @Override
        public EpoxyModel<?> next() {
            this.checkForComodification();
            int i = this.cursor;
            this.cursor = i + 1;
            this.lastRet = i;
            return (EpoxyModel)ModelList.this.get(i);
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ModelList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ModelList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ModelList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static interface ModelListObserver {
        public void onItemRangeInserted(int var1, int var2);

        public void onItemRangeRemoved(int var1, int var2);
    }
}

