/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.EpoxyVisibilityItem;
import com.airbnb.epoxy.ModelGroupHolder;
import com.airbnb.viewmodeladapter.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 =2\u00020\u0001:\u0003=>?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020#J\u000e\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004J\u001a\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u0010H\u0002J\u001a\u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010(\u001a\u00020)H\u0002J \u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020)H\u0002J0\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\u0004H\u0002J\u0010\u00106\u001a\u00020#2\u0006\u00105\u001a\u00020\u0004H\u0002J(\u00107\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u00108\u001a\u0002092\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020)H\u0002J\b\u0010:\u001a\u00020#H\u0002J(\u0010;\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00042\u0006\u00108\u001a\u0002032\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020)H\u0002J\u0006\u0010<\u001a\u00020#R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/airbnb/epoxy/EpoxyVisibilityTracker;", "", "()V", "attachedRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "itemAnimatorFinishedListener", "Landroidx/recyclerview/widget/RecyclerView$ItemAnimator$ItemAnimatorFinishedListener;", "lastAdapterSeen", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "listener", "Lcom/airbnb/epoxy/EpoxyVisibilityTracker$Listener;", "nestedTrackers", "", "observer", "Lcom/airbnb/epoxy/EpoxyVisibilityTracker$DataObserver;", "onChangedEnabled", "", "getOnChangedEnabled", "()Z", "setOnChangedEnabled", "(Z)V", "partialImpressionThresholdPercentage", "", "getPartialImpressionThresholdPercentage", "()Ljava/lang/Integer;", "setPartialImpressionThresholdPercentage", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "visibilityIdToItemMap", "Landroid/util/SparseArray;", "Lcom/airbnb/epoxy/EpoxyVisibilityItem;", "visibilityIdToItems", "", "visibleDataChanged", "attach", "", "recyclerView", "clearVisibilityStates", "detach", "processChangeEvent", "debug", "", "checkItemAnimator", "processChangeEventWithDetachedView", "detachedView", "Landroid/view/View;", "processChild", "child", "detachEvent", "eventOriginForDebug", "viewHolder", "Lcom/airbnb/epoxy/EpoxyViewHolder;", "processChildRecyclerViewAttached", "childRecyclerView", "processChildRecyclerViewDetached", "processModelGroupChildren", "epoxyHolder", "Lcom/airbnb/epoxy/ModelGroupHolder;", "processNewAdapterIfNecessary", "processVisibilityEvents", "requestVisibilityCheck", "Companion", "DataObserver", "Listener", "epoxy-adapter_release"})
public final class EpoxyVisibilityTracker {
    private final RecyclerView.ItemAnimator.ItemAnimatorFinishedListener itemAnimatorFinishedListener = new RecyclerView.ItemAnimator.ItemAnimatorFinishedListener(this){
        final /* synthetic */ EpoxyVisibilityTracker this$0;

        public final void onAnimationsFinished() {
            EpoxyVisibilityTracker.access$processChangeEvent(this.this$0, "ItemAnimatorFinishedListener.onAnimationsFinished", false);
        }
        {
            this.this$0 = epoxyVisibilityTracker;
        }
    };
    private final SparseArray<EpoxyVisibilityItem> visibilityIdToItemMap = new SparseArray();
    private final List<EpoxyVisibilityItem> visibilityIdToItems = new ArrayList();
    private final Listener listener = new Listener();
    private final DataObserver observer = new DataObserver();
    private RecyclerView attachedRecyclerView;
    private RecyclerView.Adapter<?> lastAdapterSeen;
    private final Map<RecyclerView, EpoxyVisibilityTracker> nestedTrackers = new HashMap();
    private boolean visibleDataChanged;
    private boolean onChangedEnabled = true;
    @IntRange(from=0L, to=100L)
    @Nullable
    private Integer partialImpressionThresholdPercentage;
    private static final String TAG = "EpoxyVisibilityTracker";
    @IdRes
    private static final int TAG_ID;
    public static final boolean DEBUG_LOG = false;
    @NotNull
    public static final Companion Companion;

    public final boolean getOnChangedEnabled() {
        return this.onChangedEnabled;
    }

    public final void setOnChangedEnabled(boolean bl) {
        this.onChangedEnabled = bl;
    }

    @Nullable
    public final Integer getPartialImpressionThresholdPercentage() {
        return this.partialImpressionThresholdPercentage;
    }

    public final void setPartialImpressionThresholdPercentage(@Nullable Integer n) {
        this.partialImpressionThresholdPercentage = n;
    }

    public final void attach(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.attachedRecyclerView = recyclerView;
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.listener);
        recyclerView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.listener);
        recyclerView.addOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this.listener);
        EpoxyVisibilityTracker.Companion.setTracker(recyclerView, this);
    }

    public final void detach(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.listener);
        recyclerView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.listener);
        recyclerView.removeOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this.listener);
        EpoxyVisibilityTracker.Companion.setTracker(recyclerView, null);
        this.attachedRecyclerView = null;
    }

    public final void clearVisibilityStates() {
        this.visibilityIdToItemMap.clear();
        this.visibilityIdToItems.clear();
    }

    public final void requestVisibilityCheck() {
        EpoxyVisibilityTracker.processChangeEvent$default(this, "requestVisibilityCheck", false, 2, null);
    }

    private final void processChangeEvent(String debug, boolean checkItemAnimator) {
        RecyclerView recyclerView = this.attachedRecyclerView;
        if (recyclerView == null) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView;
        RecyclerView.ItemAnimator itemAnimator = recyclerView2.getItemAnimator();
        if (checkItemAnimator && itemAnimator != null) {
            if (itemAnimator.isRunning(this.itemAnimatorFinishedListener)) {
                this.processChangeEventWithDetachedView(null, debug);
            }
        } else {
            this.processChangeEventWithDetachedView(null, debug);
        }
    }

    static /* synthetic */ void processChangeEvent$default(EpoxyVisibilityTracker epoxyVisibilityTracker, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        epoxyVisibilityTracker.processChangeEvent(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void processChangeEventWithDetachedView(View detachedView, String debug) {
        int n;
        RecyclerView recyclerView = this.attachedRecyclerView;
        if (recyclerView == null) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView;
        this.processNewAdapterIfNecessary();
        View view = detachedView;
        if (view != null) {
            View view2 = view;
            n = 0;
            boolean bl = false;
            View it = view2;
            boolean bl2 = false;
            this.processChild(it, true, debug);
        }
        int n2 = 0;
        n = recyclerView2.getChildCount();
        while (n2 < n) {
            void i;
            View child = recyclerView2.getChildAt((int)i);
            if (child != null && child != detachedView) {
                this.processChild(child, false, debug);
            }
            ++i;
        }
    }

    private final void processNewAdapterIfNecessary() {
        block2: {
            RecyclerView recyclerView = this.attachedRecyclerView;
            if (recyclerView == null || (recyclerView = recyclerView.getAdapter()) == null) break block2;
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            boolean bl2 = false;
            RecyclerView adapter = recyclerView2;
            boolean bl3 = false;
            if (Intrinsics.areEqual(this.lastAdapterSeen, (Object)adapter) ^ true) {
                RecyclerView.Adapter<?> adapter2 = this.lastAdapterSeen;
                if (adapter2 != null) {
                    adapter2.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.observer);
                }
                adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.observer);
                this.lastAdapterSeen = adapter;
            }
        }
    }

    private final void processChild(View child, boolean detachEvent, String eventOriginForDebug) {
        RecyclerView.ViewHolder viewHolder;
        RecyclerView recyclerView = this.attachedRecyclerView;
        if (recyclerView == null) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView;
        boolean isParentValid = child.getParent() == null || child.getParent() == recyclerView2;
        RecyclerView.ViewHolder viewHolder2 = viewHolder = isParentValid ? recyclerView2.getChildViewHolder(child) : null;
        if (viewHolder instanceof EpoxyViewHolder) {
            EpoxyHolder epoxyHolder = ((EpoxyViewHolder)viewHolder).getHolder();
            this.processChild(recyclerView2, child, detachEvent, eventOriginForDebug, (EpoxyViewHolder)viewHolder);
            if (epoxyHolder instanceof ModelGroupHolder) {
                this.processModelGroupChildren(recyclerView2, (ModelGroupHolder)epoxyHolder, detachEvent, eventOriginForDebug);
            }
        }
    }

    private final void processModelGroupChildren(RecyclerView recyclerView, ModelGroupHolder epoxyHolder, boolean detachEvent, String eventOriginForDebug) {
        for (EpoxyViewHolder groupChildHolder : epoxyHolder.getViewHolders()) {
            if (groupChildHolder.itemView instanceof RecyclerView) {
                if (detachEvent) {
                    View view = groupChildHolder.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"groupChildHolder.itemView");
                    this.processChildRecyclerViewDetached((RecyclerView)view);
                } else {
                    View view = groupChildHolder.itemView;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"groupChildHolder.itemView");
                    this.processChildRecyclerViewAttached((RecyclerView)view);
                }
            }
            View view = groupChildHolder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"groupChildHolder.itemView");
            EpoxyViewHolder epoxyViewHolder = groupChildHolder;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)epoxyViewHolder), (String)"groupChildHolder");
            this.processChild(recyclerView, view, detachEvent, eventOriginForDebug, epoxyViewHolder);
        }
    }

    private final void processChild(RecyclerView recyclerView, View child, boolean detachEvent, String eventOriginForDebug, EpoxyViewHolder viewHolder) {
        block1: {
            boolean changed = this.processVisibilityEvents(recyclerView, viewHolder, detachEvent, eventOriginForDebug);
            if (!changed || !(child instanceof RecyclerView)) break block1;
            EpoxyVisibilityTracker epoxyVisibilityTracker = this.nestedTrackers.get(child);
            if (epoxyVisibilityTracker != null) {
                EpoxyVisibilityTracker.processChangeEvent$default(epoxyVisibilityTracker, "parent", false, 2, null);
            }
        }
    }

    private final boolean processVisibilityEvents(RecyclerView recyclerView, EpoxyViewHolder epoxyHolder, boolean detachEvent, String eventOriginForDebug) {
        View view = epoxyHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"epoxyHolder.itemView");
        View itemView = view;
        int id2 = System.identityHashCode(itemView);
        EpoxyVisibilityItem vi = (EpoxyVisibilityItem)this.visibilityIdToItemMap.get(id2);
        if (vi == null) {
            vi = new EpoxyVisibilityItem(epoxyHolder.getAdapterPosition());
            this.visibilityIdToItemMap.put(id2, (Object)vi);
            this.visibilityIdToItems.add(vi);
        } else if (epoxyHolder.getAdapterPosition() != -1 && vi.getAdapterPosition() != epoxyHolder.getAdapterPosition()) {
            vi.reset(epoxyHolder.getAdapterPosition());
        }
        boolean changed = false;
        if (vi.update(itemView, (ViewGroup)recyclerView, detachEvent)) {
            vi.handleVisible(epoxyHolder, detachEvent);
            Integer n = this.partialImpressionThresholdPercentage;
            if (n != null) {
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int percentage = ((Number)n2).intValue();
                boolean bl3 = false;
                vi.handlePartialImpressionVisible(epoxyHolder, detachEvent, percentage);
            }
            vi.handleFocus(epoxyHolder, detachEvent);
            vi.handleFullImpressionVisible(epoxyHolder, detachEvent);
            changed = vi.handleChanged(epoxyHolder, this.onChangedEnabled);
        }
        return changed;
    }

    private final void processChildRecyclerViewAttached(RecyclerView childRecyclerView) {
        EpoxyVisibilityTracker epoxyVisibilityTracker = EpoxyVisibilityTracker.Companion.getTracker(childRecyclerView);
        if (epoxyVisibilityTracker == null) {
            EpoxyVisibilityTracker epoxyVisibilityTracker2 = new EpoxyVisibilityTracker();
            boolean bl = false;
            boolean bl2 = false;
            EpoxyVisibilityTracker nested = epoxyVisibilityTracker2;
            boolean bl3 = false;
            nested.partialImpressionThresholdPercentage = this.partialImpressionThresholdPercentage;
            nested.attach(childRecyclerView);
            epoxyVisibilityTracker = nested;
        }
        EpoxyVisibilityTracker tracker = epoxyVisibilityTracker;
        this.nestedTrackers.put(childRecyclerView, tracker);
    }

    private final void processChildRecyclerViewDetached(RecyclerView childRecyclerView) {
        this.nestedTrackers.remove(childRecyclerView);
    }

    static {
        Companion = new Companion(null);
        TAG_ID = R.id.epoxy_visibility_tracker;
    }

    public static final /* synthetic */ void access$setAttachedRecyclerView$p(EpoxyVisibilityTracker $this, RecyclerView recyclerView) {
        $this.attachedRecyclerView = recyclerView;
    }

    public static final /* synthetic */ void access$processChangeEvent(EpoxyVisibilityTracker $this, String debug, boolean checkItemAnimator) {
        $this.processChangeEvent(debug, checkItemAnimator);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016JP\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/airbnb/epoxy/EpoxyVisibilityTracker$Listener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "Landroid/view/View$OnLayoutChangeListener;", "Landroidx/recyclerview/widget/RecyclerView$OnChildAttachStateChangeListener;", "(Lcom/airbnb/epoxy/EpoxyVisibilityTracker;)V", "onChildViewAttachedToWindow", "", "child", "Landroid/view/View;", "onChildViewDetachedFromWindow", "onLayoutChange", "recyclerView", "left", "", "top", "right", "bottom", "oldLeft", "oldTop", "oldRight", "oldBottom", "onScrolled", "Landroidx/recyclerview/widget/RecyclerView;", "dx", "dy", "epoxy-adapter_release"})
    private final class Listener
    extends RecyclerView.OnScrollListener
    implements View.OnLayoutChangeListener,
    RecyclerView.OnChildAttachStateChangeListener {
        public void onLayoutChange(@NotNull View recyclerView, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            EpoxyVisibilityTracker.processChangeEvent$default(EpoxyVisibilityTracker.this, "onLayoutChange", false, 2, null);
        }

        public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
            Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            EpoxyVisibilityTracker.processChangeEvent$default(EpoxyVisibilityTracker.this, "onScrolled", false, 2, null);
        }

        public void onChildViewAttachedToWindow(@NotNull View child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (child instanceof RecyclerView) {
                EpoxyVisibilityTracker.this.processChildRecyclerViewAttached((RecyclerView)child);
            }
            EpoxyVisibilityTracker.this.processChild(child, false, "onChildViewAttachedToWindow");
        }

        public void onChildViewDetachedFromWindow(@NotNull View child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (child instanceof RecyclerView) {
                EpoxyVisibilityTracker.this.processChildRecyclerViewDetached((RecyclerView)child);
            }
            if (EpoxyVisibilityTracker.this.visibleDataChanged) {
                EpoxyVisibilityTracker.this.processChangeEventWithDetachedView(child, "onChildViewDetachedFromWindow");
                EpoxyVisibilityTracker.this.visibleDataChanged = false;
            } else {
                EpoxyVisibilityTracker.this.processChild(child, true, "onChildViewDetachedFromWindow");
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/airbnb/epoxy/EpoxyVisibilityTracker$DataObserver;", "Landroidx/recyclerview/widget/RecyclerView$AdapterDataObserver;", "(Lcom/airbnb/epoxy/EpoxyVisibilityTracker;)V", "notEpoxyManaged", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onChanged", "", "onItemMoved", "fromPosition", "", "toPosition", "onItemRangeInserted", "positionStart", "itemCount", "onItemRangeMoved", "onItemRangeRemoved", "epoxy-adapter_release"})
    public final class DataObserver
    extends RecyclerView.AdapterDataObserver {
        public void onChanged() {
            if (this.notEpoxyManaged(EpoxyVisibilityTracker.this.attachedRecyclerView)) {
                return;
            }
            EpoxyVisibilityTracker.this.visibilityIdToItemMap.clear();
            EpoxyVisibilityTracker.this.visibilityIdToItems.clear();
            EpoxyVisibilityTracker.this.visibleDataChanged = true;
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            if (this.notEpoxyManaged(EpoxyVisibilityTracker.this.attachedRecyclerView)) {
                return;
            }
            for (EpoxyVisibilityItem item : EpoxyVisibilityTracker.this.visibilityIdToItems) {
                if (item.getAdapterPosition() < positionStart) continue;
                EpoxyVisibilityTracker.this.visibleDataChanged = true;
                item.shiftBy(itemCount);
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            if (this.notEpoxyManaged(EpoxyVisibilityTracker.this.attachedRecyclerView)) {
                return;
            }
            for (EpoxyVisibilityItem item : EpoxyVisibilityTracker.this.visibilityIdToItems) {
                if (item.getAdapterPosition() < positionStart) continue;
                EpoxyVisibilityTracker.this.visibleDataChanged = true;
                item.shiftBy(-itemCount);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (this.notEpoxyManaged(EpoxyVisibilityTracker.this.attachedRecyclerView)) {
                return;
            }
            int n = 0;
            int n2 = itemCount;
            while (n < n2) {
                void i;
                this.onItemMoved(fromPosition + i, toPosition + i);
                ++i;
            }
        }

        private final void onItemMoved(int fromPosition, int toPosition) {
            if (this.notEpoxyManaged(EpoxyVisibilityTracker.this.attachedRecyclerView)) {
                return;
            }
            for (EpoxyVisibilityItem item : EpoxyVisibilityTracker.this.visibilityIdToItems) {
                int n;
                int position = item.getAdapterPosition();
                if (position == fromPosition) {
                    item.shiftBy(toPosition - fromPosition);
                    EpoxyVisibilityTracker.this.visibleDataChanged = true;
                    continue;
                }
                if (fromPosition < toPosition) {
                    n = position;
                    if (fromPosition + 1 > n || toPosition < n) continue;
                    item.shiftBy(-1);
                    EpoxyVisibilityTracker.this.visibleDataChanged = true;
                    continue;
                }
                if (fromPosition <= toPosition || toPosition > (n = position) || fromPosition <= n) continue;
                item.shiftBy(1);
                EpoxyVisibilityTracker.this.visibleDataChanged = true;
            }
        }

        private final boolean notEpoxyManaged(RecyclerView recyclerView) {
            return recyclerView == null || !(recyclerView.getAdapter() instanceof BaseEpoxyAdapter);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/airbnb/epoxy/EpoxyVisibilityTracker$Companion;", "", "()V", "DEBUG_LOG", "", "TAG", "", "TAG_ID", "", "getTracker", "Lcom/airbnb/epoxy/EpoxyVisibilityTracker;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "setTracker", "", "tracker", "epoxy-adapter_release"})
    public static final class Companion {
        private final EpoxyVisibilityTracker getTracker(RecyclerView recyclerView) {
            return (EpoxyVisibilityTracker)recyclerView.getTag(TAG_ID);
        }

        private final void setTracker(RecyclerView recyclerView, EpoxyVisibilityTracker tracker) {
            recyclerView.setTag(TAG_ID, (Object)tracker);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

